/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlplatform.security.dto.PasswordValidationResult;
import com.xebialabs.xlrelease.api.v1.forms.UserAccount;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.validators.UserAccountValidator;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.SessionService;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.service.Users;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.SortSupport;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.users.UserFilters;
import io.micrometer.core.annotation.Timed;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;

@Path(value="/users")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class UserAccountResource {
    private final UserService userService;
    private final Users users;
    private final UserProfileService userProfileService;
    private final PermissionChecker permissionChecker;
    private final SessionService sessionService;
    private final UserAccountValidator userAccountValidator;

    @Autowired
    public UserAccountResource(UserService userService, Users users, UserProfileService userProfileService, PermissionChecker permissionChecker, SessionService sessionService, UserAccountValidator userAccountValidator) {
        this.userService = userService;
        this.users = users;
        this.userProfileService = userProfileService;
        this.permissionChecker = permissionChecker;
        this.sessionService = sessionService;
        this.userAccountValidator = userAccountValidator;
    }

    @GET
    public Page<UserAccount> find(@BeanParam UserFilters userFilters, @DefaultValue(value="0") @QueryParam(value="page") Integer page, @DefaultValue(value="50") @QueryParam(value="resultsPerPage") Integer resultsPerPage, @Context UriInfo uriInfo) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        Checks.checkArgument(((long)resultsPerPage.intValue() <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than %d", (Object[])new Object[]{100L});
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage, (Sort)SortSupport.toSort(uriInfo));
        Page<UserProfile> userProfiles = this.userProfileService.searchUserAccounts(userFilters, (Pageable)pageable);
        List<String> internalNames = this.users.getRepositoryUsernames();
        return userProfiles.map(p -> {
            String name = UserAccountResource.extractName(p.getId());
            boolean isInternal = this.isInternalUser(internalNames, p.getName());
            return new UserAccount(name, p, isInternal);
        });
    }

    @GET
    @Timed
    @Path(value="names")
    public List<UserView> getUsernames() {
        List<UserProfile> allUserProfiles = this.userProfileService.findAll(false);
        return allUserProfiles.stream().map(profile -> new UserView(profile.getId(), profile.getFullName(), profile.getEmail())).collect(Collectors.toList());
    }

    @POST
    public void create(UserAccount account) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        this.userAccountValidator.check(account);
        this.checkNoUserProfileAlreadyExists(account.getUsername());
        boolean created = this.insertUser(account);
        if (!created) {
            throw new UserAlreadyExistsException(account.getUsername());
        }
        this.userProfileService.save(account.toUserProfile());
    }

    @PUT
    @Timed
    public Response update(UserAccount account) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        String username = account.getUsername();
        Checks.checkArgument((boolean)Strings.isNotBlank((String)username), (String)"User name cannot be empty.", (Object[])new Object[0]);
        UserProfile profile = this.userProfileService.findByUsername(username);
        if (profile == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        profile.setEmail(account.getEmail());
        profile.setFullName(account.getFullName());
        profile.setLoginAllowed(account.isLoginAllowed());
        this.userProfileService.updateProfile(profile);
        if (account.hasPassword() && this.users.userExistsInRepository(username)) {
            this.userAccountValidator.checkPassword(account.getPassword());
            if (this.isUsernameLoggedIn(username)) {
                this.userService.modifyPassword(username, account.getPassword(), account.getPreviousPassword());
            } else {
                this.userService.modifyPassword(username, account.getPassword());
            }
            this.sessionService.disconnect(username);
        }
        return Response.ok().build();
    }

    @DELETE
    @Timed
    public void delete(UserAccount account) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        String username = account.getUsername();
        Checks.checkArgument((boolean)Strings.isNotBlank((String)username), (String)"User name cannot be empty.", (Object[])new Object[0]);
        Checks.checkArgument((!XLReleasePermissions.isAdmin((String)username) ? 1 : 0) != 0, (String)"Admin user cannot be deleted.", (Object[])new Object[0]);
        this.userService.delete(username);
        this.userProfileService.deleteByUsername(username);
        this.sessionService.disconnect(username);
    }

    @POST
    @Timed
    @Path(value="validatePassword")
    public List<PasswordValidationResult> validatePassword(UserAccount account) {
        String password = account.getPassword() == null ? "" : account.getPassword();
        return this.userAccountValidator.validatePassword(password);
    }

    private boolean isUsernameLoggedIn(String username) {
        return username.equalsIgnoreCase(User.AUTHENTICATED_USER.getName());
    }

    private void checkNoUserProfileAlreadyExists(String username) {
        boolean userProfileExists;
        boolean bl = userProfileExists = this.userProfileService.findByUsername(username) != null;
        if (userProfileExists) {
            throw new UserAlreadyExistsException(username);
        }
    }

    private boolean insertUser(UserAccount account) {
        try {
            this.userService.create(account.getUsername(), account.getPassword());
        }
        catch (UserAlreadyExistsException e) {
            return false;
        }
        return true;
    }

    private boolean isInternalUser(List<String> internalNames, String name) {
        for (String internalName : internalNames) {
            if (!name.equalsIgnoreCase(internalName)) continue;
            return true;
        }
        return false;
    }

    private static String extractName(String id) {
        return id.replace(UserProfileService.ROOT + "/", "");
    }
}

