/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.xlrelease.api.v1.CacheManagementApi;
import com.xebialabs.xlrelease.api.v1.views.CacheGroupView;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CacheManagementService;
import io.micrometer.core.annotation.Timed;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class CacheManagementApiImpl
implements CacheManagementApi {
    private final CacheManagementService cacheManagementService;
    private final PermissionChecker permissions;

    @Autowired
    public CacheManagementApiImpl(CacheManagementService cacheManagementService, PermissionChecker permissions) {
        this.cacheManagementService = cacheManagementService;
        this.permissions = permissions;
    }

    @Timed
    public List<CacheGroupView> listCacheGroups() {
        this.checkAdmin();
        return this.cacheManagementService.listCacheGroups().stream().map(CacheGroupView::new).toList();
    }

    @Timed
    public void clearAllCacheGroups() {
        this.checkAdmin();
        this.cacheManagementService.clearAllCacheGroups(true);
    }

    @Timed
    public void clearCacheGroup(String cacheGroup) {
        this.checkAdmin();
        this.cacheManagementService.clearCacheGroup(cacheGroup, true);
    }

    private void checkAdmin() {
        if (!this.permissions.isCurrentUserAdmin()) {
            throw new PermissionDeniedException("Only admin users can perform this operation");
        }
    }
}

