/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.customscript;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.BaseScriptTaskExecutor;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.scheduler.CustomScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.WorkManager;
import com.xebialabs.xlrelease.script.TaskSoftReference;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomScriptTaskExecutor
extends BaseScriptTaskExecutor<CustomScriptTask> {
    private static final Logger logger = LoggerFactory.getLogger(CustomScriptTaskExecutor.class);

    @Autowired
    public CustomScriptTaskExecutor(WorkManager workManager, TaskRepository taskRepository) {
        super(workManager, taskRepository);
    }

    @Override
    public Class<CustomScriptTask> getTaskClass() {
        return CustomScriptTask.class;
    }

    @Override
    public void execute(TaskSoftReference<CustomScriptTask> taskRef) {
        CustomScriptTask task = taskRef.get();
        if (!task.isInProgress() && !task.isAbortScriptInProgress()) {
            logger.info("Not executing script of task {} as it is {}", (Object)task, (Object)task.getStatus());
            return;
        }
        this.fixVariableMapping(task);
        CustomScriptTaskJob job = new CustomScriptTaskJob(taskRef);
        if (task.isAbortScriptInProgress()) {
            this.workManager.replace(job);
        } else {
            this.workManager.submit(job);
        }
    }

    private void fixVariableMapping(CustomScriptTask task) {
        Collection outputProperties = task.getPythonScript().getOutputProperties();
        boolean updated = false;
        for (PropertyDescriptor propertyDescriptor : outputProperties) {
            String propertyName = propertyDescriptor.getName();
            String fqPropertyName = "pythonScript." + propertyName;
            Object propertyValue = task.getPythonScript().getProperty(propertyName);
            if (!(propertyValue instanceof String) || !VariableHelper.containsOnlyVariable((String)((String)propertyValue)) || task.getVariableMapping().containsKey(fqPropertyName)) continue;
            logger.debug("adding variable pre 5.0 [{}] with value [{}]", (Object)fqPropertyName, propertyValue);
            task.getVariableMapping().put(fqPropertyName, (String)propertyValue);
            updated = true;
        }
        if (updated) {
            this.taskRepository.update((Task)task);
        }
    }
}

