package com.xebialabs.deployit.plumbing;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.xlrelease.api.v1.views.ExplodedDescriptor;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

import static com.xebialabs.deployit.plumbing.AbstractConfigurationItemReaderWriter.getClassFromGenericType;
import static java.nio.charset.StandardCharsets.UTF_8;

@Component
@Provider
@Produces({MediaType.APPLICATION_JSON})
public class ExplodedDescriptorsJsonWriter implements MessageBodyWriter<Collection<ExplodedDescriptor>> {

    @Override
    public boolean isWriteable(Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = getClassFromGenericType(genericType);
        }
        return ExplodedDescriptor.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(final Collection<ExplodedDescriptor> descriptors, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType, final MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(descriptors).getBytes(UTF_8));
    }

    @VisibleForTesting
    String toJson(Collection<ExplodedDescriptor> descriptors) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);
        writer.array();

        for (ExplodedDescriptor descriptor : descriptors) {
            new ExplodedDescriptorJsonWriter().writeJson(descriptor, writer);
        }

        writer.endArray();
        return stringWriter.toString();
    }
}
