package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.views.ArtifactView;
import com.xebialabs.xltype.serialization.json.JsonWriter;



@Component
@Provider
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_HTML})
public class ReleaseArtifactViewJsonWriter implements MessageBodyWriter<ArtifactView> {

    @Override
    public boolean isWriteable(final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return ArtifactView.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(final ArtifactView artifactView, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType, final MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);

        ReleaseArtifactViewsJsonWriter.writeReleaseArtifactView(writer, artifactView);

        entityStream.write(stringWriter.toString().getBytes(StandardCharsets.UTF_8));
    }
}
