package com.xebialabs.deployit.plumbing;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.jackson.JsonProcessingExceptionMapper;
import org.springframework.stereotype.Component;
import com.fasterxml.jackson.core.JsonProcessingException;

@Provider
@Component
public class ReleaseJsonProcessingExceptionMapper extends JsonProcessingExceptionMapper {

    private final IOExceptionMapper ioExceptionMapper;

    public ReleaseJsonProcessingExceptionMapper(IOExceptionMapper ioExceptionMapper) {
       this.ioExceptionMapper = ioExceptionMapper;
    }

    @Override
    public Response toResponse(final JsonProcessingException exception) {
        return ioExceptionMapper.toResponse(exception);
    }
}
