package com.xebialabs.xlrelease.actors.extension

import org.apache.pekko.actor.Actor
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.{List => JList}
import scala.jdk.CollectionConverters._

@Component
class ActorExtensionRegistry {

  private var handlerFactories: Seq[ActorExtensionHandlerFactory] = Seq.empty

  def getHandlerFactoriesForActorType(clazz: Class[_ <: Actor]): Seq[ActorExtensionHandlerFactory] =
    handlerFactories.filter(_.supports(clazz))

  def getHandlerFactories: Seq[ActorExtensionHandlerFactory] = handlerFactories

  @Autowired(required = false)
  def setHandlerFactories(handlerFactories: JList[ActorExtensionHandlerFactory]): Unit = {
    this.handlerFactories = handlerFactories.asScala.toSeq
  }

}
