package com.xebialabs.xlrelease.api.internal;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.xlrelease.service.SseService;

@Path("/system-notifications")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@Controller
public class SystemNotificationsResource {

    public static final String SYSTEM_NOTIFICATION_SINK_ID = "SystemNotification";

    private SseService sseService;

    @Autowired
    public SystemNotificationsResource(SseService sseService) {
        this.sseService = sseService;
    }

    @POST
    public void subscribeToNotifications() {
        this.sseService.subscribeTopicToUser(SYSTEM_NOTIFICATION_SINK_ID);
    }

}
