package com.xebialabs.xlrelease.events.handlers

import com.xebialabs.xlrelease.domain.events.FolderMovedEvent
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import com.xebialabs.xlrelease.service.CacheManagementService
import grizzled.slf4j.Logging
import org.springframework.stereotype.Service

@Service
@EventListener
class FolderEventHandler(cacheManagementService: CacheManagementService) extends Logging {

  @Subscribe
  def onFolderMoved(event: FolderMovedEvent): Unit = {
    logger.trace("Clearing all cache groups due to folder move event")
    cacheManagementService.clearAllCacheGroups(true)
  }
}
