package com.xebialabs.xlrelease.events.handlers

import com.xebialabs.deployit.engine.spi.event.{SpringInstantiatedListener, SystemStartedEvent}
import com.xebialabs.xlrelease.service.PreArchiveService
import grizzled.slf4j.Logging
import nl.javadude.t2bus.Subscribe

class PreArchiveServiceInitializer(preArchiveService: PreArchiveService) extends SpringInstantiatedListener with Logging {

  @Subscribe def startPreArchiving(event: SystemStartedEvent): Unit = {
    try {
      preArchiveService.start()
    } catch {
      case e: Exception => logger.error("Error while starting pre-archiving service", e)
    }
  }

}
