package com.xebialabs.xlrelease.security

import com.xebialabs.deployit.engine.api.dto.{Ordering, Paging}
import com.xebialabs.deployit.security.Role
import com.xebialabs.xlrelease.api.v1.filters.RolePrincipalsFilters
import com.xebialabs.xlrelease.views.RolePrincipalsView
import org.springframework.data.domain.{Page, Pageable}

import java.util

trait ReleaseRoleRepository {
  //TODO: Use Pageable and return Page. Kept it as it is for public API backward compatibility for now.
  def getGlobalRoles(rolePattern: String, paging: Paging, order: Ordering): util.List[Role]

  def getGlobalRolePrincipals(filters: RolePrincipalsFilters, pageable: Pageable): Page[RolePrincipalsView]

  def create(onConfigurationItem: String, roles: Role*): Unit

  def update(onConfigurationItem: String, roles: Role*): Unit

  def renameGlobalRole(oldName: String, newName: String): Unit

  def deleteGlobalRole(roleId: String): Unit

  def globalRoleExists(roleName: String): Boolean

  def getGlobalRole(roleName: String): Option[Role]

  def getGlobalRolePrincipal(roleName: String): Option[RolePrincipalsView]
}
