package com.xebialabs.xlrelease.upgrade.json

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.security.XLReleasePermissions._
import com.xebialabs.xlrelease.upgrade.Components._
import org.codehaus.jettison.json.JSONArray

class XLRelease600EditTriggersPermissionJson extends XLReleaseEditTriggersPermissionJson {

  override def getUpgradeVersion: Version = Version.valueOf(XL_RELEASE_COMPONENT, "6.0.0#7")

  protected def processPermissions(permissionsJSONArray: JSONArray, permissions: Seq[String]): Unit = {
    if (permissions.contains(EDIT_TEMPLATE.getPermissionName) &&
      !permissions.contains(EDIT_TEMPLATE_TRIGGERS.getPermissionName)) {
      permissionsJSONArray.put(EDIT_TEMPLATE_TRIGGERS.getPermissionName)
    }
  }

}
