package com.xebialabs.xlrelease.upgrade.json

import com.xebialabs.deployit.booter.local.utils.Strings
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.export.TemplateJsonHelper._
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.{JsonUpgrade, UpgradeResult}
import org.codehaus.jettison.json.JSONObject
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

abstract class BaseXLReleaseReplaceXldDeployitTaskJsonUpgrade() extends JsonUpgrade {

  override def performUpgrade(release: JSONObject): UpgradeResult = {
    logger.debug(s"Replacing Deployit tasks in release ${release.optString("id")}")
    val updated = replaceDeployitTasks(getTasksFromRelease(release).asScala.toSeq)

    new UpgradeResult(updated, Seq.empty.asJava)
  }

  private def replaceDeployitTasks(tasks: Seq[JSONObject]): Boolean = {
    val r = tasks.map { task =>
      task.optString("type") match {
        case "xlrelease.DeployitTask" => createXLDeployPluginTasks(task)
        case _ => false
      }
    }
    r.contains(true)
  }

  private def createXLDeployPluginTasks(task: JSONObject): Boolean = {
    task.put("type", "xlrelease.CustomScriptTask")
    val pythonScript = new JSONObject()
    pythonScript.put("id", s"${task.getString("id")}/PythonScript")
    pythonScript.put("type", "xldeploy.Deploy")
    pythonScript.put("customScriptTask", task.getString("id"))
    pythonScript.put("server", getNewXldServerId(task.optString("server")))
    pythonScript.put("deploymentPackage", task.optString("deploymentPackage"))
    pythonScript.put("deploymentEnvironment", task.optString("environment"))
    pythonScript.put("username", task.optString("username", null))
    pythonScript.put("password", task.optString("password", null))
    pythonScript.put("xlDeployTaskId", task.optString("deployitTaskId"))
    task.put("pythonScript", pythonScript)

    cleanTask(task)
    true
  }

  private def cleanTask(task: JSONObject) = {
    task.remove("server")
    task.remove("environment")
    task.remove("deploymentPackage")
    task.remove("currentStep")
    task.remove("currentStepTitle")
    task.remove("totalStep")
    task.remove("username")
    task.remove("password")
    task.remove("deployitTaskId")
  }

  private  def getNewXldServerId(oldDeployitServerId: String): String =
    oldDeployitServerId match {
      case id if Strings.isNotBlank(id) => id.replace("Configuration/Deployit/", "Configuration/Custom/Configuration")
      case _ => null
    }

}

@Component
class XLRelease610ReplaceXldDeployitTaskJsonUpgrade extends BaseXLReleaseReplaceXldDeployitTaskJsonUpgrade {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "6.1.0#4")

}

/**
  * A copy of [[XLRelease610ReplaceXldDeployitTaskJsonUpgrade]] to kick in before the
  * [[com.xebialabs.xlrelease.upgrade.json.XLRelease480UpgradeVariablesJson]] and solve the
  * "unknown type xlrelease.DeployitTask" error. So when upgrading a template from 4.7 to 6.1+ the
  * "ReplaceXldDeployitTask" upgrade will run twice.
  */
@Component
class XLRelease480ReplaceXldDeployitTaskJsonUpgrade extends BaseXLReleaseReplaceXldDeployitTaskJsonUpgrade {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "4.8.0#2")

}
