package com.xebialabs.xlrelease.upgrade.settings

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry.getDescriptor
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.configuration.TriggerDataPurgeSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

class TriggerDataPurgeSettingsInitializer @Autowired()(configurationRepository: ConfigurationRepository) extends BaseInitializingUpgrade with Logging {
  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "10.1.0#1")

  override def doUpgrade(): Boolean = {
    val ci: TriggerDataPurgeSettings = getDescriptor(Type.valueOf(classOf[TriggerDataPurgeSettings])).newInstance(TriggerDataPurgeSettings.TRIGGER_DATA_PURGE_SETTINGS_ID)
    configurationRepository.create(ci)
    true
  }
}
