package com.xebialabs.xlrelease.views;

import java.util.List;

import com.xebialabs.xlrelease.domain.status.PhaseStatus;

public class PhaseFullView extends PlanItemFullView {
    private PhaseStatus status;
    private List<TaskFullView> tasks;
    private String color;
    private int taskFailureCount = 0;
    private int taskFlaggedCount = 0;
    private int taskDelayCount = 0;

    private boolean isOrigin;
    private boolean isMostRecentCopy; // == last node but also the latest created
    private String originId;

    public PhaseFullView() {
    }

    public boolean isOrigin() {
        return isOrigin;
    }

    public void setOrigin(final boolean origin) {
        isOrigin = origin;
    }

    public String getOriginId() {
        return originId;
    }

    public void setOriginId(final String originId) {
        this.originId = originId;
    }

    public boolean isMostRecentCopy() {
        return isMostRecentCopy;
    }

    public void setMostRecentCopy(final boolean mostRecentCopy) {
        isMostRecentCopy = mostRecentCopy;
    }

    public PhaseStatus getStatus() {
        return status;
    }

    public void setStatus(PhaseStatus status) {
        this.status = status;
    }

    public List<TaskFullView> getTasks() {
        return tasks;
    }

    public void setTasks(List<TaskFullView> tasks) {
        this.tasks = tasks;
    }

    public void setColor(final String color) {
        this.color = color;
    }

    public String getColor() {
        return color;
    }

    public void setTaskFailureCount(final int taskFailureCount) {
        this.taskFailureCount = taskFailureCount;
    }

    public int getTaskFailureCount() {
        return taskFailureCount;
    }

    public void setTaskFlaggedCount(final int taskFlaggedCount) {
        this.taskFlaggedCount = taskFlaggedCount;
    }

    public int getTaskFlaggedCount() {
        return taskFlaggedCount;
    }

    public void setTaskDelayCount(final int taskDelayCount) {
        this.taskDelayCount = taskDelayCount;
    }

    public int getTaskDelayCount() {
        return taskDelayCount;
    }
}
