package com.xebialabs.xlrelease.views.teams

import com.fasterxml.jackson.core.JsonParser
import com.fasterxml.jackson.databind.{DeserializationContext, JsonDeserializer}
import org.springframework.stereotype.Component

@Component
class OptionalStringDeserializer extends JsonDeserializer[Option[_]] {
  override def deserialize(p: JsonParser, ctxt: DeserializationContext): Option[String] = {
    val value = p.getValueAsString
    if (value == null || value.isBlank) {
      None
    } else {
      Some(value)
    }
  }

  override def getNullValue(): Option[_] = {
    None
  }

  override def getNullValue(ctxt: DeserializationContext): Option[_] = {
    None
  }
}
