package com.xebialabs.xlrelease.api.internal

import com.xebialabs.deployit.plugin.api.reflect.Type
import org.springframework.stereotype.Controller

import jakarta.ws.rs._
import jakarta.ws.rs.core.MediaType


@Path("/metadata")
@Consumes(Array(MediaType.APPLICATION_JSON))
@Produces(Array(MediaType.APPLICATION_JSON))
@Controller
class MetadataResource {

  @GET
  @Path("types-hierarchy")
  def getTypesHierarchy(@QueryParam("focusType") focusType: String, @QueryParam("topType") topType: String): TypeNode = {
    TypeNode.buildHierarchy(Type.valueOf(focusType), Type.valueOf(topType))
  }
}
