package com.xebialabs.xlrelease.api.internal

import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.api.internal.ReleaseServerUrlDecorator.SERVER_URL
import com.xebialabs.xlrelease.domain.{Release, ServerUrl}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util
import scala.jdk.CollectionConverters._

object ReleaseServerUrlDecorator {
  val SERVER_URL = "serverUrl"
}

@Component
class ReleaseServerUrlDecorator @Autowired()(serverConfiguration: ServerConfiguration) extends CachedInternalMetadataDecorator[Release, Unit] {

  override val name: String = SERVER_URL

  override def isApplicableTo(ci: ConfigurationItem): Boolean = ci.isInstanceOf[Release]

  override def decorate(cis: util.Collection[Release], cache: DecoratorCache[Unit]): Unit = {
    cis.asScala.foreach { release =>
        release.get$metadata().put(SERVER_URL, ServerUrl(serverConfiguration.getServerUrl))
    }
  }
}
