package com.xebialabs.xlrelease.dispatcher

import com.typesafe.config.Config
import org.apache.pekko.dispatch.DispatcherPrerequisites
import org.apache.pekko.dispatch.xlrelease.XlrDispatcherPrerequisites

import java.util.concurrent.ForkJoinPool

class XlrDispatcherConfigurator(config: Config, prerequisites: DispatcherPrerequisites, otherPrerequisites: DispatcherPrerequisites)
  extends org.apache.pekko.dispatch.DispatcherConfigurator(config, otherPrerequisites) {

  def this(config: Config, prerequisites: DispatcherPrerequisites) = {

    this(config, prerequisites, XlrDispatcherPrerequisites(
      prerequisites.threadFactory match {
        case forkJoinThreadFactory: ForkJoinPool.ForkJoinWorkerThreadFactory => new XlrDispatcherForkJoinWorkerThreadFactory(forkJoinThreadFactory)
        case _ => new XlrDispatcherThreadFactory(prerequisites.threadFactory)
      },
      prerequisites.eventStream,
      prerequisites.scheduler,
      prerequisites.dynamicAccess,
      prerequisites.settings,
      prerequisites.mailboxes,
      prerequisites.defaultExecutionContext
    ))
  }
}
