package com.xebialabs.xlrelease.server.jetty

import com.xebialabs.deployit.engine.spi.event.SystemStartedEvent
import com.xebialabs.deployit.event.EventBusHolder
import com.xebialabs.deployit.{ServerConfiguration, ServerState}
import com.xebialabs.xlrelease.XLReleaseBootstrapper
import grizzled.slf4j.Logging
import org.springframework.boot.context.event.{ApplicationFailedEvent, ApplicationReadyEvent}
import org.springframework.context.event.EventListener

import java.lang.System.err

class JettyServerListener(val serverConfiguration: ServerConfiguration) extends Logging {
  final private val serverState = ServerState.getInstance

  @EventListener
  def onApplicationReadyEvent(event: ApplicationReadyEvent): Unit = {
    EventBusHolder.register(serverState)
    EventBusHolder.publish(new SystemStartedEvent)

    logger.info(s"${XLReleaseBootstrapper.PRODUCT_DIGITALAI} has started.")
    logger.info(s"You can now point your browser to ${serverConfiguration.getServerUrl}\n")
  }

  @EventListener
  def onApplicationFailedEvent(event: ApplicationFailedEvent): Unit = {
    val displayMsg = String.format("%s Startup failed: %s%n", XLReleaseBootstrapper.PRODUCT_DIGITALAI, event.getException.getMessage)
    err.println()
    err.println("################################################################################")
    err.println()
    err.println(displayMsg)
    err.println()
    err.println("################################################################################")
    err.println()
  }

}
