package com.xebialabs.xlrelease.views;

import java.util.Map;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.serialization.json.jackson.PasswordDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.PasswordSerializer;

import static com.xebialabs.xlrelease.variable.VariableHelper.containsOnlyVariable;
import static com.xebialabs.xlrelease.variable.VariableHelper.formatVariableIfNeeded;

public class VariableOrPasswordView extends VariableOrValueView {

    public VariableOrPasswordView() {
    }

    public VariableOrPasswordView(String variable, String password) {
        if (variable != null) {
            this.setVariable(formatVariableIfNeeded(variable));
            this.setValue(password);
        } else {
            if (containsOnlyVariable(password)) {
                this.setVariable(password);
                this.setValue(null);
            } else {
                this.setVariable(null);
                this.setValue(password);
            }
        }
    }

    public VariableOrPasswordView(String password) {
        this(null, password);
    }

    public VariableOrPasswordView(Map<String, String> deserializedView) {
        this(deserializedView.get("variable"), deserializedView.get("value"));
    }

    @JsonSerialize(using = PasswordSerializer.class)
    @JsonDeserialize(using = PasswordDeserializer.class)
    public String getValue() {
        return (String) value;
    }

    public void setValue(String password) {
        this.value = password;
    }

    public String variableOrValue() {
        return getVariable() != null ? formatVariableIfNeeded(getVariable()) : getValue();
    }
}
