/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.Exceptions;
import com.xebialabs.deployit.Sanitizer;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Provider
@Component
public class IOExceptionMapper
implements ExceptionMapper<IOException> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean hideInternals;

    public IOExceptionMapper(ServerConfiguration serverConfiguration) {
        this.hideInternals = serverConfiguration.isHideInternals();
    }

    public Response toResponse(IOException exception) {
        String content = Exceptions.getAllMessages((Exception)exception);
        Response handled = this.checkWhetherWeHideInternals(exception, content);
        if (handled != null) {
            return handled;
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain");
        builder.header("X-Exception-Type", (Object)exception.getClass().getName());
        builder.header("X-Path", PathInterceptor.PATH.get());
        builder.header("Date", (Object)new Date());
        builder.entity((Object)Sanitizer.sanitize((String)content));
        return builder.build();
    }

    private Response checkWhetherWeHideInternals(IOException e, String content) {
        if (this.hideInternals) {
            UUID uuid = UUID.randomUUID();
            this.logger.error("[UUID={}] Exception: {}", (Object)uuid, (Object)e.getClass().getName());
            this.logger.error("[UUID={}] Error messages: {}", (Object)uuid, (Object)content);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)("An internal error has occurred, please notify your system administrator with the following code: " + uuid)).build();
        }
        return null;
    }
}

