/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseInformation;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.security.PermissionChecker$;
import com.xebialabs.xlrelease.security.PermissionContext;
import com.xebialabs.xlrelease.security.PermissionContextEnv;
import com.xebialabs.xlrelease.security.ReleasePermissionContext$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r]f!B)S\u0001JS\u0006\u0002C?\u0001\u0005+\u0007I\u0011\u0001@\t\u0013\u0005\u0015\u0001A!E!\u0002\u0013y\bbBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0005\n\u0003\u001f\u0001!\u0019!C\u0005\u0003#A\u0001\"!\u0012\u0001A\u0003%\u00111\u0003\u0005\n\u0003\u000f\u0002!\u0019!C\u0005\u0003\u0013B\u0001\"!\u001a\u0001A\u0003%\u00111J\u0003\u0007\u0003O\u0002\u0001!a\t\t\u0013\u0005%\u0004A1A\u0005\n\u0005-\u0004\u0002CA@\u0001\u0001\u0006I!!\u001c\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\"9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0005bBAH\u0001\u0011%\u0011\u0011\u0013\u0005\u000b\u0003/\u0003\u0001R1A\u0005\u0002\u0005e\u0005bBAN\u0001\u0011\u0005\u0013Q\u0014\u0005\b\u0003O\u0003A\u0011IAU\u0011\u001d\ti\u000b\u0001C!\u0003_Cq!a-\u0001\t\u0003\n)\fC\u0004\u0002:\u0002!\t%a/\t\u000f\u0005u\u0006\u0001\"\u0011\u0002@\"9\u00111\u0019\u0001\u0005B\u0005\u0015\u0007bBAe\u0001\u0011\u0005\u00131\u001a\u0005\b\u0003\u001f\u0004A\u0011IAi\u0011\u001d\t)\u000e\u0001C\u0005\u0003/Dq!a7\u0001\t\u0013\ti\u000eC\u0004\u0002b\u0002!I!a9\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002j\"A\u0011\u0011\u001f\u0001\u0005\u0002I\u000b\u0019\u0010\u0003\u0005\u0002z\u0002!\tAUA~\u0011!\u0011\u0019\u0001\u0001C\u0001%\n\u0015\u0001b\u0002B\u0011\u0001\u0011%!1\u0005\u0005\b\u0005C\u0001A\u0011\u0002B\u0014\u0011\u001d\u0011Y\u0003\u0001C!\u0005[AqA!\r\u0001\t\u0013\u0011\u0019\u0004C\u0004\u00038\u0001!\tE!\u000f\t\u000f\tu\u0002\u0001\"\u0011\u0003@!9!1\t\u0001\u0005\n\t\u0015\u0003\u0002\u0003B1\u0001\u0011\u0005!Ka\u0019\t\u000f\t\u001d\u0004\u0001\"\u0011\u0003j!9!Q\u000e\u0001\u0005\n\t=\u0004b\u0002B:\u0001\u0011\u0005#Q\u000f\u0005\b\u0005s\u0002A\u0011\tB>\u0011\u001d\u0011y\b\u0001C!\u0005\u0003CqA!\"\u0001\t\u0003\u00129\tC\u0004\u0003\u0010\u0002!\tE!%\t\u000f\t=\u0005\u0001\"\u0003\u0003&\"9!1\u0016\u0001\u0005\n\t5\u0006b\u0002B_\u0001\u0011\u0005#q\u0018\u0005\b\u0005\u0007\u0004A\u0011\tBc\u0011!\u0011I\r\u0001C\u0001%\n-\u0007\u0002\u0003Bh\u0001\u0011\u0005!K!5\t\u000f\tU\u0007\u0001\"\u0003\u0003X\"A!1\u001c\u0001\u0005\u0002I\u0013i\u000eC\u0004\u0003b\u0002!\tEa9\t\u000f\t\u0005\b\u0001\"\u0003\u0003h\"9!1\u001e\u0001\u0005B\t5\bb\u0002By\u0001\u0011\u0005#1\u001f\u0005\b\u0005o\u0004A\u0011\u0002B}\u0011\u001d\u0011i\u0010\u0001C!\u0005\u007fD\u0001ba\u0001\u0001\t\u0003\u00116Q\u0001\u0005\b\u0007\u0013\u0001A\u0011IB\u0006\u0011\u001d\u0019y\u0001\u0001C!\u0007#A\u0011b!\u0006\u0001\u0003\u0003%\taa\u0006\t\u0013\rm\u0001!%A\u0005\u0002\ru\u0001\"CB\u0018\u0001\u0005\u0005I\u0011IB\u0019\u0011%\u0019\t\u0005AA\u0001\n\u0003\u0019\u0019\u0005C\u0005\u0004L\u0001\t\t\u0011\"\u0001\u0004N!I1\u0011\f\u0001\u0002\u0002\u0013\u000531\f\u0005\n\u0007K\u0002\u0011\u0011!C\u0001\u0007OB\u0011ba\u001b\u0001\u0003\u0003%\te!\u001c\t\u0013\rE\u0004!!A\u0005B\rM\u0004\"CB;\u0001\u0005\u0005I\u0011IB<\u0011%\u0019I\bAA\u0001\n\u0003\u001aYh\u0002\u0006\u0004\u0000I\u000b\t\u0011#\u0001S\u0007\u00033\u0011\"\u0015*\u0002\u0002#\u0005!ka!\t\u000f\u0005\u001d1\n\"\u0001\u0004\u001c\"I1QO&\u0002\u0002\u0013\u00153q\u000f\u0005\n\u0007;[\u0015\u0011!CA\u0007?C\u0011ba)L\u0003\u0003%\ti!*\t\u0013\r56*!A\u0005\n\r=&\u0001\u0007*fY\u0016\f7/\u001a)fe6L7o]5p]\u000e{g\u000e^3yi*\u00111\u000bV\u0001\tg\u0016\u001cWO]5us*\u0011QKV\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0016-\u0002\u0013a,'-[1mC\n\u001c(\"A-\u0002\u0007\r|Wn\u0005\u0004\u00017\u0006,W\u000e\u001d\t\u00039~k\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t\u001cW\"\u0001*\n\u0005\u0011\u0014&!\u0005)fe6L7o]5p]\u000e{g\u000e^3yiB\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\u0006g24GG\u001b\u0006\u0002U\u0006AqM]5{u2,G-\u0003\u0002mO\n9Aj\\4hS:<\u0007C\u0001/o\u0013\tyWLA\u0004Qe>$Wo\u0019;\u0011\u0005EThB\u0001:y\u001d\t\u0019x/D\u0001u\u0015\t)h/\u0001\u0004=e>|GOP\u0002\u0001\u0013\u0005q\u0016BA=^\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001f?\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005el\u0016aA3omV\tq\u0010E\u0002c\u0003\u0003I1!a\u0001S\u0005Q\u0001VM]7jgNLwN\\\"p]R,\u0007\u0010^#om\u0006!QM\u001c<!\u0003\u0019a\u0014N\\5u}Q!\u00111BA\u0007!\t\u0011\u0007\u0001C\u0003~\u0007\u0001\u0007q0A\nsK2,\u0017m]3J]\u001a|'/\\1uS>t7/\u0006\u0002\u0002\u0014AA\u0011QCA\u0010\u0003G\t\u0019$\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u001diW\u000f^1cY\u0016T1!!\b^\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003C\t9BA\u0002NCB\u0004B!!\n\u0002.9!\u0011qEA\u0015!\t\u0019X,C\u0002\u0002,u\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0018\u0003c\u0011aa\u0015;sS:<'bAA\u0016;B)A,!\u000e\u0002:%\u0019\u0011qG/\u0003\r=\u0003H/[8o!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA )\u0006Q!/\u001a9pg&$xN]=\n\t\u0005\r\u0013Q\b\u0002\u0013%\u0016dW-Y:f\u0013:4wN]7bi&|g.\u0001\u000bsK2,\u0017m]3J]\u001a|'/\\1uS>t7\u000fI\u0001\u0012O2|'-\u00197QKJl\u0017n]:j_:\u001cXCAA&!!\t)\"a\b\u0002N\u0005}\u0003\u0003BA(\u00037j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\u000ba\u0016\u0014X.[:tS>t'bA*\u0002X)\u0019\u0011\u0011\f,\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!!\u0018\u0002R\tQ\u0001+\u001a:nSN\u001c\u0018n\u001c8\u0011\u0007q\u000b\t'C\u0002\u0002du\u0013qAQ8pY\u0016\fg.\u0001\nhY>\u0014\u0017\r\u001c)fe6L7o]5p]N\u0004#A\u0002+bg.LE-\u0001\buCN\\G)\u0019;b\u0019>|7.\u001e9\u0016\u0005\u00055\u0004\u0003CA\u000b\u0003?\ty'a\u001d\u0011\u0007\u0005E\u0004\"D\u0001\u0001!\u0011\t)(a\u001f\u000e\u0005\u0005]$\u0002BA=\u0003{\tQ!];fefLA!! \u0002x\tiA+Y:l\u0005\u0006\u001c\u0018n\u0019#bi\u0006\fq\u0002^1tW\u0012\u000bG/\u0019'p_.,\b\u000fI\u0001\u0013e\u0016dW-Y:f\u0013:4wN]7bi&|g\u000e\u0006\u0003\u00024\u0005\u0015\u0005bBAD\u0017\u0001\u0007\u00111E\u0001\ne\u0016dW-Y:f\u0013\u0012\f1\u0003[1t\u000f2|'-\u00197QKJl\u0017n]:j_:$B!a\u0018\u0002\u000e\"9\u00111\u000b\u0007A\u0002\u00055\u0013aC4fiR\u000b7o\u001b#bi\u0006$B!a\u001d\u0002\u0014\"9\u0011QS\u0007A\u0002\u0005=\u0014A\u0002;bg.LE-\u0001\njg\u000e+(O]3oiV\u001bXM]!e[&tWCAA0\u0003%\u0019\u0007.Z2l-&,w\u000f\u0006\u0003\u0002 \u0006\u0015\u0006c\u0001/\u0002\"&\u0019\u00111U/\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u000f{\u0001\u0019AA\u0012\u0003%\u0019\u0007.Z2l\u000b\u0012LG\u000f\u0006\u0003\u0002 \u0006-\u0006bBAD!\u0001\u0007\u00111E\u0001\u000eG\",7m[#eSR$\u0016m]6\u0015\t\u0005}\u0015\u0011\u0017\u0005\b\u0003\u000f\u000b\u0002\u0019AA\u0012\u0003]\u0019\u0007.Z2l\u0019>\u001c7\u000eV1tWB+'/\\5tg&|g\u000e\u0006\u0003\u0002 \u0006]\u0006bBAD%\u0001\u0007\u00111E\u0001%G\",7m\u001b'pG.$\u0016m]6QKJl\u0017n]:j_:4uN]!tg&<g.\\3oiR\u0011\u0011qT\u0001 G\",7m[#eSR\u0004&/Z2p]\u0012LG/[8o!\u0016\u0014X.[:tS>tG\u0003BAP\u0003\u0003Dq!a\"\u0015\u0001\u0004\t\u0019#A\u0011dQ\u0016\u001c7.\u00123ji\u001a\u000b\u0017\u000e\\;sK\"\u000bg\u000e\u001a7feB+'/\\5tg&|g\u000e\u0006\u0003\u0002 \u0006\u001d\u0007bBAD+\u0001\u0007\u00111E\u0001\fG\u0006tW\tZ5u)\u0006\u001c8\u000e\u0006\u0003\u0002`\u00055\u0007bBAD-\u0001\u0007\u00111E\u0001\u000fG\u0006tg+[3x%\u0016dW-Y:f)\u0011\ty&a5\t\u000f\u0005\u001du\u00031\u0001\u0002$\u0005A\u0012n],pe.4Gn\\<Fq\u0016\u001cW\u000f^5p]>;h.\u001a:\u0015\t\u0005}\u0013\u0011\u001c\u0005\b\u0003\u000fC\u0002\u0019AA\u0012\u0003II7oQ;se\u0016tG/V:fe>;h.\u001a:\u0015\t\u0005}\u0013q\u001c\u0005\b\u0003\u000fK\u0002\u0019AA\u0012\u0003MI7oV8sW\u001adwn^#yK\u000e,H/[8o)\u0011\ty&!:\t\u000f\u0005\u001d%\u00041\u0001\u0002$\u0005)1\r[3dWR1\u0011qTAv\u0003[Dq!a\u0015\u001c\u0001\u0004\ti\u0005C\u0004\u0002pn\u0001\r!a\t\u0002\t\rL\u0017\nZ\u0001\u000eQ\u0006\u001c\b+\u001a:nSN\u001c\u0018n\u001c8\u0015\r\u0005}\u0013Q_A|\u0011\u001d\t\u0019\u0006\ba\u0001\u0003\u001bBq!a<\u001d\u0001\u0004\t\u0019#A\biCN\u001c\u0015\u000eU3s[&\u001c8/[8o)\u0019\ty&!@\u0002\u0000\"9\u00111K\u000fA\u0002\u00055\u0003b\u0002B\u0001;\u0001\u0007\u00111E\u0001\fG>tG/Y5oKJLE-\u0001\u0005dQ\u0016\u001c7.\u00118z)\u0019\tyJa\u0002\u0003\n!9\u0011q\u001e\u0010A\u0002\u0005\r\u0002b\u0002B\u0006=\u0001\u0007!QB\u0001\fa\u0016\u0014X.[:tS>t7\u000fE\u0003]\u0005\u001f\ti%C\u0002\u0003\u0012u\u0013!\u0002\u0010:fa\u0016\fG/\u001a3?Q\rq\"Q\u0003\t\u0005\u0005/\u0011i\"\u0004\u0002\u0003\u001a)\u0019!1D/\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003 \te!a\u0002<be\u0006\u0014xm]\u0001\u0012O\u0016$h+[3x!\u0016\u0014X.[:tS>tG\u0003BA'\u0005KAq!a\" \u0001\u0004\t\u0019\u0003\u0006\u0003\u0002N\t%\u0002bBAAA\u0001\u0007\u0011\u0011H\u0001\u000bG\",7m[!c_J$H\u0003BAP\u0005_Aq!a\"\"\u0001\u0004\t\u0019#\u0001\u0006jg^{'o\u001b4m_^$B!a\u0018\u00036!9\u0011q\u0011\u0012A\u0002\u0005\r\u0012aE2iK\u000e\\W\tZ5u\u0003R$\u0018m\u00195nK:$H\u0003BAP\u0005wAq!a<$\u0001\u0004\t\u0019#A\u0013dQ\u0016\u001c7.S:BY2|w/\u001a3U_\u0016#\u0017\u000e^!ui\u0006\u001c\u0007.\\3oiN|e\u000eV1tWR!\u0011q\u0014B!\u0011\u001d\t)\n\na\u0001\u0003G\tAa\\<ogR!\u0011q\fB$\u0011\u001d\t)*\na\u0001\u0003GAS!\nB&\u0005;\u0002R\u0001\u0018B'\u0005#J1Aa\u0014^\u0005\u0019!\bN]8xgB!!1\u000bB-\u001b\t\u0011)F\u0003\u0003\u0003X\u0005]\u0013!C3yG\u0016\u0004H/[8o\u0013\u0011\u0011YF!\u0016\u0003#9{GOR8v]\u0012,\u0005pY3qi&|g.\t\u0002\u0003`\u0005i\u0013N\u001a\u0011uCN\\\u0017\n\u001a\u0011jg\u0002rw\u000e\u001e\u0011g_VtG\rI5oAI,\u0007o\\:ji>\u0014\u0018\u0010\t3bi\u0006\u0014\u0017m]3\u00023!\f7\u000fU3s[&\u001c8/[8o)>,\u0006\u000fZ1uKR\u000b7o\u001b\u000b\u0005\u0003?\u0012)\u0007C\u0004\u0002\u0016\u001a\u0002\r!a\t\u0002?\rDWmY6FI&$H+Y:l\u0007>tg-[4ve\u0006$\u0018n\u001c8GC\u000e,G\u000f\u0006\u0003\u0002 \n-\u0004bBADO\u0001\u0007\u00111E\u0001\u001eG\u0006tW\tZ5u)\u0006\u001c8nQ8oM&<WO]1uS>tg)Y2fiR!\u0011q\fB9\u0011\u001d\t9\t\u000ba\u0001\u0003_\nQb\u00195fG.,E-\u001b;ECR,G\u0003BAP\u0005oBq!a<*\u0001\u0004\t\u0019#A\u000edQ\u0016\u001c7.\u00123ji\nc\u0017mY6pkR\u0004VM]7jgNLwN\u001c\u000b\u0005\u0003?\u0013i\bC\u0004\u0002\b*\u0002\r!a\u001c\u00027\rDWmY6SK\u0006\u001c8/[4o)\u0006\u001c8\u000eU3s[&\u001c8/[8o)\u0011\tyJa!\t\u000f\u0005\u001d5\u00061\u0001\u0002$\u000592\r[3dWJ+\u0017m]:jO:$\u0016m]6U_V\u001bXM\u001d\u000b\u0007\u0003?\u0013IIa#\t\u000f\u0005UE\u00061\u0001\u0002p!9!Q\u0012\u0017A\u0002\u0005=\u0014a\u00028foV\u001bXM]\u0001\u001aCJ,Wk]3sg&sG\u000b[3TC6,G+Y:l)\u0016\fW\u000e\u0006\u0004\u0002`\tM%1\u0015\u0005\b\u0005+k\u0003\u0019\u0001BL\u0003\u0011!\u0018m]6\u0011\t\te%qT\u0007\u0003\u00057S1A!(U\u0003\u0019!w.\\1j]&!!\u0011\u0015BN\u0005\u0011!\u0016m]6\t\u000f\t5U\u00061\u0001\u0002$Q1\u0011q\fBT\u0005SCq!!&/\u0001\u0004\t\u0019\u0003C\u0004\u0003\u000e:\u0002\r!a\t\u0002\u0019%\u001cXk]3s\u0013:$V-Y7\u0015\r\u0005}#q\u0016BZ\u0011\u001d\u0011\tl\fa\u0001\u0003G\tA!^:fe\"9!QW\u0018A\u0002\t]\u0016\u0001\u0002;fC6\u0004BA!'\u0003:&!!1\u0018BN\u0005\u0011!V-Y7\u0002+%\u001c\u0018\t\u001c7po\u0016$Gk\\,pe.|e\u000eV1tWR!\u0011q\fBa\u0011\u001d\t)\n\ra\u0001\u0003_\nQe\u00195fG.\u0014V\r\\3wC:$H+Y:l)J\fgn]5uS>t\u0007+\u001a:nSN\u001c\u0018n\u001c8\u0015\t\u0005}%q\u0019\u0005\b\u0003+\u000b\u0004\u0019AA\u0012\u0003AI7\u000fV1tWV\u0003H-\u0019;fC\ndW\r\u0006\u0003\u0002`\t5\u0007bBAKe\u0001\u0007\u0011qN\u0001\u0015G\",7m\u001b+bg.L5/\u00169eCR\f'\r\\3\u0015\t\u0005}%1\u001b\u0005\b\u0003+\u001b\u0004\u0019AA\u0012\u0003\tB\u0017m]!em\u0006t7-\u001a+bg.$&/\u00198tSRLwN\u001c)fe6L7o]5p]R!\u0011q\fBm\u0011\u001d\t9\t\u000ea\u0001\u0003G\t1\u0004[1t)\u0006\u001c8\u000e\u0016:b]NLG/[8o!\u0016\u0014X.[:tS>tG\u0003BA0\u0005?Dq!!&6\u0001\u0004\t\u0019#A\u0010dQ\u0016\u001c7\u000eS1t!\u0016\u0014X.[:tS>t7\u000fV8Va\u0012\fG/\u001a+bg.$B!a(\u0003f\"9!Q\u0013\u001cA\u0002\t]E\u0003BAP\u0005SDq!!&8\u0001\u0004\t\u0019#\u0001\u000edQ\u0016\u001c7.S:BY2|w/\u001a3U_^{'o[(o)\u0006\u001c8\u000e\u0006\u0003\u0002 \n=\bbBAKq\u0001\u0007\u00111E\u0001(G\",7m\u001b$pe2{7m\u001b+bg.\u0004VM]7jgNLwN\u001c$peR\u0013\u0018M\\:ji&|g\u000e\u0006\u0003\u0002 \nU\bb\u0002BKs\u0001\u0007!qS\u0001!Q\u0006\u001cHj\\2l)\u0006\u001c8\u000e\u0016:b]NLG/[8o!\u0016\u0014X.[:tS>t7\u000f\u0006\u0003\u0002`\tm\bb\u0002BKu\u0001\u0007!qS\u0001\u001eG\",7m[%t\u00032dwn^3e)>\u001cu.\\7f]R|e\u000eV1tWR!\u0011qTB\u0001\u0011\u001d\t)j\u000fa\u0001\u0003G\t\u0001d\u00195fG.\u001c\u0015M\\(wKJ\u0014\u0018\u000eZ3CY\u0006\u001c7n\\;u)\u0011\tyja\u0002\t\u000f\u0005UE\b1\u0001\u0002$\u0005i2\r[3dWR\u000b7o\u001b+sC:\u001c\u0018\u000e^5p]B+'/\\5tg&|g\u000e\u0006\u0003\u0002 \u000e5\u0001bBAK{\u0001\u0007\u0011qN\u0001%G\",7m[!em\u0006t7-\u001a+bg.$&/\u00198tSRLwN\u001c)fe6L7o]5p]R!\u0011qTB\n\u0011\u001d\t)J\u0010a\u0001\u0003G\tAaY8qsR!\u00111BB\r\u0011\u001dix\b%AA\u0002}\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004 )\u001aqp!\t,\u0005\r\r\u0002\u0003BB\u0013\u0007Wi!aa\n\u000b\t\r%\"\u0011D\u0001\nk:\u001c\u0007.Z2lK\u0012LAa!\f\u0004(\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0019\u0019\u0004\u0005\u0003\u00046\r}RBAB\u001c\u0015\u0011\u0019Ida\u000f\u0002\t1\fgn\u001a\u0006\u0003\u0007{\tAA[1wC&!\u0011qFB\u001c\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0019)\u0005E\u0002]\u0007\u000fJ1a!\u0013^\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0019ye!\u0016\u0011\u0007q\u001b\t&C\u0002\u0004Tu\u00131!\u00118z\u0011%\u00199fQA\u0001\u0002\u0004\u0019)%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007;\u0002baa\u0018\u0004b\r=SBAA\u000e\u0013\u0011\u0019\u0019'a\u0007\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003?\u001aI\u0007C\u0005\u0004X\u0015\u000b\t\u00111\u0001\u0004P\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0019\u0019da\u001c\t\u0013\r]c)!AA\u0002\r\u0015\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\r\u0015\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\rM\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002`\ru\u0004\"CB,\u0013\u0006\u0005\t\u0019AB(\u0003a\u0011V\r\\3bg\u0016\u0004VM]7jgNLwN\\\"p]R,\u0007\u0010\u001e\t\u0003E.\u001bRaSBC\u0007#\u0003raa\"\u0004\u000e~\fY!\u0004\u0002\u0004\n*\u001911R/\u0002\u000fI,h\u000e^5nK&!1qRBE\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\t\u0005\u0007'\u001bI*\u0004\u0002\u0004\u0016*!1qSB\u001e\u0003\tIw.C\u0002|\u0007+#\"a!!\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\u0005-1\u0011\u0015\u0005\u0006{:\u0003\ra`\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u00199k!+\u0011\tq\u000b)d \u0005\n\u0007W{\u0015\u0011!a\u0001\u0003\u0017\t1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019\t\f\u0005\u0003\u00046\rM\u0016\u0002BB[\u0007o\u0011aa\u00142kK\u000e$\b")
public class ReleasePermissionContext
implements PermissionContext,
Logging,
Product,
Serializable {
    private boolean isCurrentUserAdmin;
    private final PermissionContextEnv env;
    private final Map<String, Option<ReleaseInformation>> releaseInformations;
    private final Map<Permission, Object> globalPermissions;
    private final Map<String, TaskBasicData> taskDataLookup;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<PermissionContextEnv> unapply(ReleasePermissionContext x$0) {
        return ReleasePermissionContext$.MODULE$.unapply(x$0);
    }

    public static ReleasePermissionContext apply(PermissionContextEnv env) {
        return ReleasePermissionContext$.MODULE$.apply(env);
    }

    public static <A> Function1<PermissionContextEnv, A> andThen(Function1<ReleasePermissionContext, A> g) {
        return ReleasePermissionContext$.MODULE$.andThen(g);
    }

    public static <A> Function1<A, ReleasePermissionContext> compose(Function1<A, PermissionContextEnv> g) {
        return ReleasePermissionContext$.MODULE$.compose(g);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleasePermissionContext releasePermissionContext = this;
        synchronized (releasePermissionContext) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public void checkAny(String ciId, Permission ... permissions) {
        this.checkAny(ciId, (Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])permissions));
    }

    public PermissionContextEnv env() {
        return this.env;
    }

    private Map<String, Option<ReleaseInformation>> releaseInformations() {
        return this.releaseInformations;
    }

    private Map<Permission, Object> globalPermissions() {
        return this.globalPermissions;
    }

    private Map<String, TaskBasicData> taskDataLookup() {
        return this.taskDataLookup;
    }

    private Option<ReleaseInformation> releaseInformation(String releaseId) {
        Option result = (Option)this.releaseInformations().getOrElseUpdate((Object)releaseId, (Function0 & Serializable)() -> {
            block0: {
                this.logger().debug((Function0 & Serializable)() -> "Release information requested for releaseId: " + releaseId + ".");
                if (this.releaseInformations().size() <= 0) break block0;
                this.logger().error((Function0 & Serializable)() -> "Unexpected release information requested for releaseId: " + releaseId + ". Current entries: " + this.releaseInformations().keys());
            }
            return this.env().getReleaseInformation(releaseId);
        });
        return result;
    }

    @Override
    public boolean hasGlobalPermission(Permission permission) {
        return BoxesRunTime.unboxToBoolean((Object)this.globalPermissions().getOrElseUpdate((Object)permission, (Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            this.logger().debug((Function0 & Serializable)() -> "Requested check for global permission " + permission);
            return this.env().hasGlobalPermission(permission);
        }));
    }

    private TaskBasicData getTaskData(String taskId) {
        return (TaskBasicData)this.taskDataLookup().getOrElseUpdate((Object)taskId, (Function0 & Serializable)() -> this.env().getTaskData(taskId));
    }

    private boolean isCurrentUserAdmin$lzycompute() {
        ReleasePermissionContext releasePermissionContext = this;
        synchronized (releasePermissionContext) {
            if (!this.bitmap$0) {
                this.isCurrentUserAdmin = this.env().isCurrentUserAdmin();
                this.bitmap$0 = true;
            }
        }
        return this.isCurrentUserAdmin;
    }

    public boolean isCurrentUserAdmin() {
        if (!this.bitmap$0) {
            return this.isCurrentUserAdmin$lzycompute();
        }
        return this.isCurrentUserAdmin;
    }

    @Override
    public void checkView(String releaseId) {
        if (!this.hasGlobalPermission(XLReleasePermissions.AUDIT_ALL)) {
            if (!this.isWorkflowExecutionOwner(releaseId)) {
                this.check(this.getViewPermission(releaseId), releaseId);
                return;
            }
            return;
        }
    }

    @Override
    public void checkEdit(String releaseId) {
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You cannot edit " + releaseId));
        });
        Permission permissionToCheck = releaseInfo.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE;
        this.check(permissionToCheck, releaseId);
    }

    @Override
    public void checkEditTask(String releaseId) {
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You cannot edit task on " + releaseId));
        });
        Permission permissionToCheck = releaseInfo.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE_TASK;
        this.check(permissionToCheck, releaseId);
    }

    @Override
    public void checkLockTaskPermission(String releaseId) {
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You cannot lock task on " + releaseId));
        });
        Permission permissionToCheck = releaseInfo.isTemplate() ? XLReleasePermissions.LOCK_TEMPLATE_TASK : XLReleasePermissions.LOCK_RELEASE_TASK;
        this.check(permissionToCheck, releaseId);
    }

    @Override
    public void checkLockTaskPermissionForAssignment() {
        if (!this.isCurrentUserAdmin()) {
            throw PermissionDeniedException.withMessage((String)"Only Release Admins can change the assignment of a locked task");
        }
    }

    @Override
    public void checkEditPreconditionPermission(String releaseId) {
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You cannot edit precondition on " + releaseId));
        });
        if (releaseInfo.isTemplate()) {
            this.check(XLReleasePermissions.EDIT_TEMPLATE_PRECONDITION, releaseId);
            return;
        }
        this.checkAny(releaseId, (Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.EDIT_RELEASE_PRECONDITION, XLReleasePermissions.EDIT_RELEASE_TASK}));
    }

    @Override
    public void checkEditFailureHandlerPermission(String releaseId) {
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You cannot edit failure handler on " + releaseId));
        });
        if (releaseInfo.isTemplate()) {
            this.check(XLReleasePermissions.EDIT_TEMPLATE_FAILURE_HANDLER, releaseId);
            return;
        }
        this.checkAny(releaseId, (Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.EDIT_RELEASE_FAILURE_HANDLER, XLReleasePermissions.EDIT_RELEASE_TASK}));
    }

    @Override
    public boolean canEditTask(String releaseId) {
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You cannot edit task on " + releaseId));
        });
        Permission permissionToCheck = releaseInfo.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE_TASK;
        return this.hasPermission(permissionToCheck, releaseId);
    }

    @Override
    public boolean canViewRelease(String releaseId) {
        return this.hasGlobalPermission(XLReleasePermissions.AUDIT_ALL) || this.isWorkflowExecutionOwner(releaseId) || this.hasCiPermission(this.getViewPermission(releaseId), releaseId);
    }

    private boolean isWorkflowExecutionOwner(String releaseId) {
        return BoxesRunTime.unboxToBoolean((Object)this.releaseInformation(releaseId).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReleasePermissionContext.$anonfun$isWorkflowExecutionOwner$2(this, releaseId, x$1))));
    }

    private boolean isCurrentUserOwner(String releaseId) {
        return BoxesRunTime.unboxToBoolean((Object)this.releaseInformation(releaseId).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReleasePermissionContext.$anonfun$isCurrentUserOwner$2(this, x$2))));
    }

    private boolean isWorkflowExecution(String releaseId) {
        return BoxesRunTime.unboxToBoolean((Object)this.releaseInformation(releaseId).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isWorkflowExecution())));
    }

    @Override
    public void check(Permission permission, String ciId) {
        boolean checkOwner;
        boolean bl = checkOwner = PermissionChecker$.MODULE$.isWorkflowRelatedPermission(permission) && this.isWorkflowExecution(ciId);
        if (checkOwner) {
            if (!this.isWorkflowExecutionOwner(ciId)) {
                throw PermissionDeniedException.withMessage((String)("You are not the owner of the workflow execution " + ciId));
            }
            return;
        }
        if (!this.hasPermission(permission, ciId)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)ciId);
        }
    }

    @Override
    public boolean hasPermission(Permission permission, String ciId) {
        return this.hasGlobalPermission(permission) || this.hasCiPermission(permission, ciId);
    }

    @Override
    public boolean hasCiPermission(Permission permission, String containerId) {
        boolean bl;
        if (!PermissionChecker$.MODULE$.isPermissionApplicableTo(permission, containerId)) {
            bl = false;
        } else {
            Option<ReleaseInformation> option = this.releaseInformation(containerId);
            if (option instanceof Some) {
                Some some = (Some)option;
                ReleaseInformation r = (ReleaseInformation)some.value();
                bl = r.isArchived() ? this.env().hasArchivedReleasePermission(permission, containerId) : (PermissionChecker$.MODULE$.isWorkflowRelatedPermission(permission) && r.isWorkflowExecution() ? this.isWorkflowExecutionOwner(containerId) : this.env().hasEffectiveSecuredCiPermission(permission, containerId));
            } else if (None$.MODULE$.equals(option)) {
                bl = this.env().hasEffectiveSecuredCiPermission(permission, containerId);
            } else {
                throw new MatchError(option);
            }
        }
        boolean hasRequiredPermission = bl;
        return hasRequiredPermission;
    }

    public void checkAny(String ciId, Seq<Permission> permissions) {
        Object object = new Object();
        try {
            permissions.foreach((Function1 & Serializable)permission -> {
                ReleasePermissionContext.$anonfun$checkAny$1(this, ciId, object, permission);
                return BoxedUnit.UNIT;
            });
            throw PermissionChecker$.MODULE$.exceptionForPermissions(ciId, permissions);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            ex.value$mcV$sp();
            return;
        }
    }

    private Permission getViewPermission(String releaseId) {
        return (Permission)this.releaseInformation(releaseId).map((Function1 & Serializable)releaseInformation -> this.getViewPermission((ReleaseInformation)releaseInformation)).getOrElse((Function0 & Serializable)() -> XLReleasePermissions.VIEW_RELEASE);
    }

    private Permission getViewPermission(ReleaseInformation releaseInformation) {
        if (releaseInformation.isTemplate()) {
            return XLReleasePermissions.VIEW_TEMPLATE;
        }
        if (releaseInformation.isWorkflowExecution()) {
            return XLReleasePermissions.VIEW_WORKFLOW_EXECUTION;
        }
        return XLReleasePermissions.VIEW_RELEASE;
    }

    @Override
    public void checkAbort(String releaseId) {
        if (this.isWorkflow(releaseId)) {
            if (!this.isWorkflowExecutionOwner(releaseId) && !this.hasPermission(XLReleasePermissions.ABORT_WORKFLOW_EXECUTION, releaseId)) {
                throw PermissionDeniedException.withMessage((String)("You are not the owner of the workflow execution or do not have " + XLReleasePermissions.ABORT_WORKFLOW_EXECUTION + " permission on " + releaseId));
            }
            return;
        }
        if (!this.hasPermission(XLReleasePermissions.ABORT_RELEASE, releaseId)) {
            throw PermissionDeniedException.forPermission((Permission)XLReleasePermissions.ABORT_RELEASE, (String)releaseId);
        }
    }

    private boolean isWorkflow(String releaseId) {
        return BoxesRunTime.unboxToBoolean((Object)this.releaseInformation(releaseId).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isWorkflow())));
    }

    @Override
    public void checkEditAttachment(String ciId) {
        if (Ids.isTaskId((String)ciId)) {
            this.checkIsAllowedToEditAttachmentsOnTask(ciId);
            return;
        }
        this.checkEdit(Ids.releaseIdFrom((String)ciId));
    }

    @Override
    public void checkIsAllowedToEditAttachmentsOnTask(String taskId) {
        try {
            String releaseId = Ids.releaseIdFrom((String)taskId);
            if (!this.hasPermissionToUpdateTask(taskId) && !this.hasPermission(XLReleasePermissions.EDIT_RELEASE_TASK_ATTACHMENT, releaseId)) {
                throw PermissionDeniedException.forNodeAndPrivilege((String)taskId, (String)"'Task owner', 'Member of task team', 'edit task' or 'edit task attachments'");
            }
        }
        catch (NotFoundException e) {
            throw PermissionDeniedException.withMessage((String)("You cannot upload attachments on archived task [" + taskId + "]"));
        }
    }

    private boolean owns(String taskId) throws NotFoundException {
        TaskBasicData taskData = this.getTaskData(taskId);
        if (taskData.owner() != null) {
            return taskData.owner().equalsIgnoreCase(Permissions.getAuthenticatedUserName());
        }
        return false;
    }

    public boolean hasPermissionToUpdateTask(String taskId) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        if (this.isCurrentUserAdmin() || this.canEditTask(releaseId) || this.owns(taskId)) {
            return true;
        }
        return Option$.MODULE$.apply((Object)this.getTaskData(taskId).team()).exists((Function1 & Serializable)team -> BoxesRunTime.boxToBoolean((boolean)ReleasePermissionContext.$anonfun$hasPermissionToUpdateTask$1(this, taskId, team)));
    }

    @Override
    public void checkEditTaskConfigurationFacet(String releaseId) {
        if (!this.canEditTask(releaseId) && !this.canEditTaskConfigurationFacet(releaseId)) {
            throw PermissionDeniedException.withMessage((String)("You are not allowed to create facets on tasks of release [" + releaseId + "]"));
        }
    }

    private boolean canEditTaskConfigurationFacet(String releaseId) {
        return this.hasPermission(XLReleasePermissions.EDIT_RELEASE_TASK_CONFIGURATION_FACET, releaseId);
    }

    @Override
    public void checkEditDate(String ciId) {
        String releaseId = Ids.releaseIdFrom((String)ciId);
        if (Ids.isReleaseId((String)ciId) || Ids.isPhaseId((String)ciId)) {
            this.checkEdit(releaseId);
            return;
        }
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You do not have permission to edit dates on " + ciId));
        });
        .colon.colon permissionsToCheck = releaseInfo.isTemplate() ? new .colon.colon((Object)XLReleasePermissions.EDIT_TEMPLATE, (List)Nil$.MODULE$) : new .colon.colon((Object)XLReleasePermissions.EDIT_RELEASE_TASK, (List)new .colon.colon((Object)XLReleasePermissions.EDIT_TASK_DATES, (List)Nil$.MODULE$));
        this.checkAny(releaseId, (Seq<Permission>)permissionsToCheck);
    }

    @Override
    public void checkEditBlackoutPermission(String releaseId) {
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You do not have permission to edit blackout on " + releaseId));
        });
        if (releaseInfo.isTemplate()) {
            this.check(XLReleasePermissions.EDIT_TEMPLATE, releaseId);
            return;
        }
        this.checkAny(releaseId, (Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.EDIT_RELEASE_TASK, XLReleasePermissions.EDIT_BLACKOUT}));
    }

    @Override
    public void checkReassignTaskPermission(String releaseId) {
        ReleaseInformation relaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You do not have permission to reassign task on " + releaseId));
        });
        if (relaseInfo.isTemplate()) {
            this.check(XLReleasePermissions.EDIT_TEMPLATE, releaseId);
            return;
        }
        this.checkAny(releaseId, (Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.EDIT_RELEASE_TASK, XLReleasePermissions.REASSIGN_RELEASE_TASK}));
    }

    @Override
    public void checkReassignTaskToUser(String taskId, String newUser) {
        block3: {
            try {
                String releaseId = Ids.releaseIdFrom((String)taskId);
                this.checkReassignTaskPermission(releaseId);
                TaskBasicData task = this.getTaskData(taskId);
                if (task.locked()) {
                    this.checkLockTaskPermissionForAssignment();
                }
            }
            catch (PermissionDeniedException e) {
                if (this.areUsersInTheSameTaskTeam(taskId, newUser)) break block3;
                throw e;
            }
        }
    }

    @Override
    public boolean areUsersInTheSameTaskTeam(Task task, String newUser) {
        return this.areUsersInTheSameTaskTeam(task.getId(), newUser);
    }

    private boolean areUsersInTheSameTaskTeam(String taskId, String newUser) {
        Authentication currentAuthentication = Permissions.getAuthentication();
        TaskBasicData task = this.getTaskData(taskId);
        if (task.team() != null) {
            String releaseId = Ids.releaseIdFrom((String)taskId);
            Option<Team> teamOptional = this.env().findTeamByName(releaseId, task.team());
            return teamOptional.exists((Function1 & Serializable)team -> BoxesRunTime.boxToBoolean((boolean)ReleasePermissionContext.$anonfun$areUsersInTheSameTaskTeam$1(this, currentAuthentication, newUser, team)));
        }
        return false;
    }

    private boolean isUserInTeam(String user, Team team) {
        return team.hasMember(user) || team.hasAnyRole(this.env().getRolesFor(user)) || this.env().isExternalUserPrincipalIsFromTheGroupAssigned(user, team);
    }

    @Override
    public boolean isAllowedToWorkOnTask(String taskId) {
        TaskBasicData task = this.getTaskData(taskId);
        return task.isUpdatable() && this.hasPermissionToUpdateTask(taskId);
    }

    @Override
    public void checkRelevantTaskTransitionPermission(String taskId) {
        this.checkTaskIsUpdatable(taskId);
        String releaseId = Ids.releaseIdFrom((String)taskId);
        TaskBasicData task = this.getTaskData(taskId);
        if (task.isPlanned()) {
            if (!this.hasAdvanceTaskTransitionPermission(releaseId)) {
                throw PermissionDeniedException.withMessage((String)("You cannot make advance task transition for task=[" + taskId + "]. You need to have permission or be release owner"));
            }
            return;
        }
        if (!this.hasTaskTransitionPermission(taskId)) {
            throw PermissionDeniedException.withMessage((String)("You cannot make task transition for task=[" + taskId + "]. You need to have permission or be either release owner or task owner"));
        }
    }

    public boolean isTaskUpdateable(String taskId) {
        TaskBasicData task = this.getTaskData(taskId);
        return task.isUpdatable();
    }

    public void checkTaskIsUpdatable(String taskId) {
        if (!this.isTaskUpdateable(taskId)) {
            throw new IllegalArgumentException("You can not work with a defunct or done in advance task");
        }
    }

    private boolean hasAdvanceTaskTransitionPermission(String releaseId) {
        return this.isCurrentUserAdmin() || this.canEditTask(releaseId) || this.hasCiPermission(XLReleasePermissions.ADVANCE_TASK_TRANSITION, releaseId);
    }

    public boolean hasTaskTransitionPermission(String taskId) {
        boolean allowReleaseOwnerTaskTransition = this.env().xlrConfig().isReleaseOwnerTaskTransitionAllowed();
        String releaseId = Ids.releaseIdFrom((String)taskId);
        return allowReleaseOwnerTaskTransition && this.isCurrentUserOwner(releaseId) || this.hasPermissionToUpdateTask(taskId) || this.hasCiPermission(XLReleasePermissions.TASK_TRANSITION, releaseId);
    }

    @Override
    public void checkHasPermissionsToUpdateTask(Task task) {
        this.checkHasPermissionsToUpdateTask(task.getId());
    }

    private void checkHasPermissionsToUpdateTask(String taskId) {
        if (!this.hasPermissionToUpdateTask(taskId)) {
            throw PermissionDeniedException.forNodeAndPrivilege((String)taskId, (String)"'Task owner', 'Member of task team' or 'edit task'");
        }
    }

    @Override
    public void checkIsAllowedToWorkOnTask(String taskId) {
        this.checkTaskIsUpdatable(taskId);
        this.checkHasPermissionsToUpdateTask(taskId);
    }

    @Override
    public void checkForLockTaskPermissionForTransition(Task task) {
        boolean isLockedTask = task.isLocked();
        if (isLockedTask && !this.isCurrentUserAdmin() && !this.hasLockTaskTransitionPermissions(task)) {
            throw PermissionDeniedException.withMessage((String)("You cannot make task transition for a locked task=[" + task.getId() + "]. You need to have locked task assigned to yourself or be part of the assigned team of the locked task"));
        }
    }

    private boolean hasLockTaskTransitionPermissions(Task task) {
        boolean canTransitionLockedTask;
        block3: {
            canTransitionLockedTask = false;
            if (this.isCurrentUserAdmin()) {
                canTransitionLockedTask = true;
            }
            if (canTransitionLockedTask) break block3;
            Release release = task.getRelease();
            Authentication currentAuthentication = Permissions.getAuthentication();
            if (!canTransitionLockedTask && task.getOwner() != null) {
                canTransitionLockedTask = this.owns(task.getId());
            }
            if (!canTransitionLockedTask && task.hasTeam()) {
                Option<Team> team = this.env().findTeamByName(release.getId(), task.getTeam());
                canTransitionLockedTask = team != null && this.isUserInTeam(currentAuthentication.getName(), (Team)team.get());
            }
        }
        return canTransitionLockedTask;
    }

    @Override
    public void checkIsAllowedToCommentOnTask(String taskId) {
        String taskReleaseId = Ids.releaseIdFrom((String)taskId);
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(taskReleaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You cannot comment task " + taskId));
        });
        if (releaseInfo.isArchived()) {
            throw PermissionDeniedException.withMessage((String)("You cannot comment on archived task [" + taskId + "]"));
        }
        if (!this.isCurrentUserAdmin()) {
            this.checkView(taskReleaseId);
            return;
        }
    }

    public void checkCanOverrideBlackout(String taskId) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        if (!this.hasCiPermission(XLReleasePermissions.EDIT_BLACKOUT, releaseId) && !this.hasCiPermission(XLReleasePermissions.EDIT_RELEASE_TASK, releaseId)) {
            throw PermissionDeniedException.forNodeAndPrivilege((String)taskId, (String)"'Edit task blackout'");
        }
    }

    @Override
    public void checkTaskTransitionPermission(String taskId) {
        this.checkTaskIsUpdatable(taskId);
        if (!this.hasTaskTransitionPermission(taskId)) {
            throw PermissionDeniedException.withMessage((String)("You cannot make task transition for task=[" + taskId + "]. You need to have permission or be either release owner or task owner"));
        }
    }

    @Override
    public void checkAdvanceTaskTransitionPermission(String taskId) {
        this.checkTaskIsUpdatable(taskId);
        TaskBasicData task = this.getTaskData(taskId);
        String releaseId = Ids.releaseIdFrom((String)taskId);
        if (task.isPlanned() && !this.hasAdvanceTaskTransitionPermission(releaseId)) {
            throw PermissionDeniedException.withMessage((String)("You cannot make advance task transition for task=[" + taskId + "]. You need to have permission or be release owner"));
        }
    }

    public ReleasePermissionContext copy(PermissionContextEnv env) {
        return new ReleasePermissionContext(env);
    }

    public PermissionContextEnv copy$default$1() {
        return this.env();
    }

    public String productPrefix() {
        return "ReleasePermissionContext";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.env();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ReleasePermissionContext;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "env";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ReleasePermissionContext)) return false;
        boolean bl = true;
        if (!bl) return false;
        ReleasePermissionContext releasePermissionContext = (ReleasePermissionContext)x$1;
        PermissionContextEnv permissionContextEnv = this.env();
        PermissionContextEnv permissionContextEnv2 = releasePermissionContext.env();
        if (permissionContextEnv == null) {
            if (permissionContextEnv2 != null) {
                return false;
            }
        } else if (!permissionContextEnv.equals(permissionContextEnv2)) return false;
        if (!releasePermissionContext.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$isWorkflowExecutionOwner$2(ReleasePermissionContext $this, String releaseId$8, ReleaseInformation x$1) {
        return x$1.isWorkflowExecution() && $this.isCurrentUserOwner(releaseId$8);
    }

    public static final /* synthetic */ boolean $anonfun$isCurrentUserOwner$2(ReleasePermissionContext $this, ReleaseInformation x$2) {
        return x$2.owner().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.equalsIgnoreCase(Permissions.getAuthenticatedUserName()))) || $this.isCurrentUserAdmin();
    }

    public static final /* synthetic */ void $anonfun$checkAny$1(ReleasePermissionContext $this, String ciId$1, Object nonLocalReturnKey1$1, Permission permission) {
        if ($this.hasPermission(permission, ciId$1)) {
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    public static final /* synthetic */ boolean $anonfun$hasPermissionToUpdateTask$1(ReleasePermissionContext $this, String taskId$2, String team) {
        return $this.env().isMemberOrRoleOf(Ids.releaseIdFrom((String)taskId$2), team);
    }

    public static final /* synthetic */ boolean $anonfun$areUsersInTheSameTaskTeam$1(ReleasePermissionContext $this, Authentication currentAuthentication$1, String newUser$1, Team team) {
        return $this.isUserInTeam(currentAuthentication$1.getName(), team) && (newUser$1 == null || $this.isUserInTeam(newUser$1, team));
    }

    public ReleasePermissionContext(PermissionContextEnv env) {
        this.env = env;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.releaseInformations = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.globalPermissions = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.taskDataLookup = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

