/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.service.UserProfileService;
import io.micrometer.core.annotation.Timed;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserInfoResolver {
    private UserProfileService userProfileService;

    @Autowired
    public UserInfoResolver(UserProfileService userProfileService) {
        this.userProfileService = userProfileService;
    }

    @Timed
    public String getNotificationEmailOf(String username) {
        if (UserInfoResolver.isUndefined(username)) {
            return null;
        }
        UserProfile profile = this.userProfileService.discover(username);
        return profile == null ? null : profile.getEmail();
    }

    @Timed
    public String getFullNameOf(String username, boolean resolveWithDataProvider) {
        if (UserInfoResolver.isUndefined(username)) {
            return null;
        }
        UserProfile profile = this.userProfileService.resolveUserProfile(username, resolveWithDataProvider);
        return profile == null ? null : profile.getFullName();
    }

    @Timed
    public String getFullNameOf(String username) {
        return this.getFullNameOf(username, true);
    }

    @Timed
    public String getFullNameOrUsernameOf(String username) {
        String fullName = this.getFullNameOf(username);
        return UserInfoResolver.getFullNameOrUsernameOf(username, fullName);
    }

    public static String getFullNameOrUsernameOf(String username, String fullName) {
        return UserInfoResolver.isUndefined(fullName) ? username : fullName;
    }

    private static boolean isUndefined(String username) {
        return Strings.isEmpty((String)com.google.common.base.Strings.nullToEmpty((String)username).trim());
    }
}

