package com.xebialabs.xlrelease.actors

import com.xebialabs.deployit.engine.spi.exception.DeployitException
import org.apache.pekko.actor.ActorSystem
import org.apache.pekko.serialization.SerializationExtension

import scala.util.{Failure, Success, Try}

trait ExceptionTranslate {
  implicit def actorSystem: ActorSystem

  //noinspection ScalaStyle
  // translate unknown exceptions thrown by various checks to DeployitException
  def translate(ex: Throwable): Throwable = {
    ex match {
      // should handle all exceptions that are mapped by ExceptionMapper
      case e: DeployitException => e
      case e =>
        val serialization = SerializationExtension.get(actorSystem)
        Try(serialization.serializerFor(e.getClass)) match {
          case Failure(_) =>
            // if there is no serializer then wrap exception
            new RemoteException(e)
          case Success(_) =>
            // if there is a serializer registered then do not wrap with remote exception
            e
        }
    }
  }
}

