package com.xebialabs.xlrelease.actors.initializer

import com.xebialabs.xlrelease.actors._
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.repository.{UserProfileRepository, UserTokenRepository}
import grizzled.slf4j.Logging
import org.apache.pekko.actor.ActorRef
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.concurrent.{Await, Promise}

@Component
class UserLastActiveInitializer @Autowired()(userProfileRepository: UserProfileRepository,
                                             userTokenRepository: UserTokenRepository,
                                             xlrConfig: XlrConfig,
                                             userLastActiveActorHolder: UserLastActiveActorHolder,
                                             systemHolder: ActorSystemHolder)
  extends ActorInitializer with Logging {

  lazy val userLastActiveActor: ActorRef = {
    import xlrConfig.features.userLastActiveActor._
    systemHolder.actorSystem.actorOf(
      UserLastActiveActor.props(userProfileRepository, userTokenRepository, maxBufferSize, batchSize, flushInterval)
    )
  }

  override def initialize(): Unit = {
    logger.debug("Initializing userLastActive actor...")
    userLastActiveActorHolder.resolveActorRef(userLastActiveActor)
    userLastActiveActor
  }
}

@Component
class UserLastActiveActorHolder @Autowired()(xlrConfig: XlrConfig) {

  private val actorPromise = Promise[ActorRef]()

  def actorRef(): ActorRef = {
    Await.result(actorPromise.future, xlrConfig.timeouts.systemInitialization)
  }

  def resolveActorRef(actorRef: ActorRef): Unit = actorPromise.success(actorRef)
}
