package com.xebialabs.xlrelease.authentication

import org.springframework.security.core.Authentication
import org.springframework.security.core.context.SecurityContextHolder

trait AuthenticationSupport {
  def withAuthentication(authentication: Authentication)(code: => Unit): Unit = {
    val previousAuthentication = SecurityContextHolder.getContext.getAuthentication
    try {
      val newCtxt = SecurityContextHolder.createEmptyContext()
      newCtxt.setAuthentication(authentication)
      SecurityContextHolder.setContext(newCtxt)
      code
    } finally {
      val newCtxt = SecurityContextHolder.createEmptyContext()
      newCtxt.setAuthentication(previousAuthentication)
      SecurityContextHolder.setContext(newCtxt)
    }
  }
}
