package com.xebialabs.xlrelease.db.sql.transaction;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.transaction.annotation.Transactional;

import com.xebialabs.deployit.exception.NotFoundException;

import static org.springframework.transaction.annotation.Isolation.READ_COMMITTED;
import static org.springframework.transaction.annotation.Propagation.REQUIRED;

@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Transactional(value = "xlrRepositoryTransactionManager", propagation = REQUIRED, isolation = READ_COMMITTED,
        rollbackFor = Throwable.class, noRollbackFor = NotFoundException.class)
public @interface IsTransactional {
}