package com.xebialabs.xlrelease.doc;

import java.io.PrintStream;

import static java.lang.String.format;

public class MarkdownWriter {

    final PrintStream out;


    public MarkdownWriter(PrintStream out) {
        this.out = out;
    }

    public PrintStream getPrintStream() {
        return out;
    }

    //
    // Stream
    //

    public void write(String s) {
        out.println(s);
    }

    public void writeEmptyLine() {
        out.println();
    }

    public void writeHeader1(String title) {
        out.println(format("# %s\n",title));
    }

    public void writeHeader2(String title) {
        out.println(format("## %s\n",title));
    }

    public void writeHeader3(String title) {
        out.println(format("### %s\n", title));
    }

    public void writeTableHeader(String... items) {
        writeTableRow(items);

        for (String item : items) {
            out.print("| --- ");
        }
        out.println("|");
    }

    public void writeTableRow(String... items) {
        for (String item : items) {
            out.print("| ");
            out.print(item);
            out.print(" ");
        }
        out.println("|");
    }

    public void writeItem(String item, Object description) {
        out.println(format("%s: %s  ", bold(item), String.valueOf(description)));
    }

    public void writeBulletPoint(String item, Object description) {
        out.println(format("* %s: %s", item, String.valueOf(description)));
    }

    //
    // Inline
    //

    public static String bold(String text) {
        return format("**%s**", text);
    }

    public static String link(String text, String link) {
        return format("[%s](%s)", text, link);
    }

    public static String code(String text) {
        return format("`%s`", text);
    }

    public static String anchor(String id) {
        return format("#%s", id.toLowerCase());
    }

}
