package com.xebialabs.xlrelease.license

import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@EventListener
class LicenseRenewalEventListener @Autowired()(licenseInstallService: XLRLicenseInstallService) extends Logging {

  @Subscribe
  def renewLicense(ev: LicenseRenewEvent): Unit = {
    logger.trace(s"Received LicenseRenewEvent. Beginning license renewal...")
    licenseInstallService.findLicenseInDB().foreach { licenseData =>
      try {
        licenseInstallService.install(licenseData)
      } catch {
        case e: Exception =>
          logger.error("Unable to install license from DB", e)
      }
    }
  }
}
