package com.xebialabs.xlrelease.principaldata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

import com.xebialabs.deployit.security.PermissionEnforcer;

import static com.xebialabs.xlrelease.principaldata.UserData.NOT_FOUND;
import static com.xebialabs.xlrelease.security.XLReleasePermissions.isAdmin;

public class DefaultUserDataProvider implements UserDataProvider {
    static final UserData ADMIN_USERDATA = new UserData("", "Release Administrator");

    @Override
    public UserData getUserData(String username) {
        if (isAdmin(username)) {
            return ADMIN_USERDATA;
        }

        return NOT_FOUND;
    }

    @Override
    public Collection<GrantedAuthority> getAuthorities(final String username) {
        List<GrantedAuthority> authorities = new ArrayList<>();
        if (isAdmin(username)) {
            authorities.add(new SimpleGrantedAuthority(PermissionEnforcer.ROLE_ADMIN));
        }
        return authorities;
    }
}
