package com.xebialabs.xlrelease.repository


import com.xebialabs.deployit.io.LimitedInputStream

import java.io.{BufferedInputStream, InputStream}

class AttachmentSizeLimiter(maxSize: Long, bytes: InputStream) extends LimitedInputStream(new BufferedInputStream(bytes), maxSize * 1024 * 1024) {
  override def raiseError(pSizeMax: Long, pCount: Long): Unit = throw new RuntimeException(s"Can not upload an attachment over $maxSize megabytes")
}
