package com.xebialabs.xlrelease.scheduler

import com.xebialabs.xlrelease.domain.runner.JobRunner
import grizzled.slf4j.Logging

import java.util.concurrent.{DelayQueue, TimeUnit}
import java.util.function.Predicate
import scala.jdk.CollectionConverters.CollectionHasAsScala

case class JobRunnerQueue(capabilities: Set[String], capacity: Integer, evictionTime: Integer, idleTimeToLive: Integer) extends Logging {

  def runnerCapabilities: Set[String] = capabilities

  private val internalJobQueue: DelayQueue[Job] = new DelayQueue[Job]()

  private def matches(job: Job): Boolean = {
    logger.trace(s"Checking if capabilities of $job matches with internal queue $this")
    val matches = job.capabilities().nonEmpty && job.capabilities().subsetOf(runnerCapabilities)
    matches
  }

  def offer(job: Job): Unit = {
    // put it into internal queue until someone asks for it
    if (matches(job)) {
      internalJobQueue.add(job)
    }
  }

  def cancelIf(predicate: Predicate[Job]): Unit = {
    internalJobQueue.removeIf(predicate)
  }

  def poll(): Job = {
    internalJobQueue.poll(50, TimeUnit.SECONDS)
  }

  def isOutdated(jobRunner: JobRunner): Boolean = {
    capabilities != jobRunner.getCapabilities.asScala.toSet ||
      capacity != jobRunner.capacity ||
      evictionTime != jobRunner.evictionTime ||
      idleTimeToLive != jobRunner.idleTimeToLive
  }
}
