package com.xebialabs.xlrelease.scheduler.domain

import com.xebialabs.xlrelease.domain.RemoteExecution
import com.xebialabs.xlrelease.domain.runner.{JobRunner, JobRunnerOps}
import com.xebialabs.xlrelease.scheduler.events.JobExecutionAbortRequestEvent
import com.xebialabs.xlrelease.service.BroadcastService
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringAwareBean
import grizzled.slf4j.Logging

trait LocalJobRunnerOps extends JobRunnerOps

object LocalJobRunnerOps extends LocalJobRunnerOps with ScalaSpringAwareBean with Logging {

  private lazy val broadcastService = springBean[BroadcastService]

  override def accepts(runner: JobRunner): Boolean = runner.isInstanceOf[LocalJobRunner]

  override def start(runner: JobRunner): Unit = {
    logger.debug(s"${runner.getId} runner does not support start operation")
  }

  override def stop(runner: JobRunner): Unit = {
    logger.debug(s"${runner.getId} runner does not support stop operation")
  }

  override def delete(runner: JobRunner): Unit = {
    logger.debug(s"${runner.getId} runner does not support delete operation")
  }

  override def abortJob(runner: JobRunner, jobId: Long, executionId: String): Unit = {
    logger.debug(s"Abort job invoked on ${runner.getId} runner for job $jobId with executionId $executionId")
    val event = JobExecutionAbortRequestEvent(jobId, executionId)
    broadcastService.broadcast(event, publishEventOnSelf = true)
  }

  override def execute(runner: JobRunner, remoteExecution: RemoteExecution): String = {
    logger.debug(s"${runner.getId} runner does not support remote execution")
    null
  }
}
