package com.xebialabs.xlrelease.scheduler.workers

import com.xebialabs.xlrelease.scheduler.Job
import com.xebialabs.xlrelease.scheduler.workers.Worker.{ExecuteJob, ProcessJobResult}
import com.xebialabs.xlrelease.script._
import org.springframework.core.PriorityOrdered

import scala.util.Try

object Worker {
  type ExecuteJob = PartialFunction[Job, ExecutionResult]

  type ProcessJobResult = PartialFunction[ExecutionResult, Unit]

  // TODO: ExecutionResult should be serializable in future to store and process result reliably. i.e. without references, options, try etc.
  sealed trait ExecutionResult

  case class FailureHandlerExecutionResult(taskId: String, executionId: String, result: Try[FailureHandlerResult]) extends ExecutionResult

  case class PreconditionExecutionResult(taskId: String, executionId: String, result: Try[PreconditionResult]) extends ExecutionResult

  case class FacetCheckExecutionResult(taskId: String, executionId: String, result: Try[FacetCheckResult]) extends ExecutionResult

  case class ScriptTaskExecutionResult(taskId: String, executionId: String, result: Try[ScriptTaskResult]) extends ExecutionResult

  case class CustomScriptTaskExecutionResult(taskId: String, executionId: String, result: Try[CustomScriptTaskResult]) extends ExecutionResult

  // create release task execution result
  sealed trait CreateReleaseTaskExecutionResult extends ExecutionResult {
    def taskId: String
  }

  case class CreateReleaseTaskExecutionResultSuccess(taskId: String,
                                                     executionId: String,
                                                     createdReleaseId: String)
    extends CreateReleaseTaskExecutionResult

  case class CreateReleaseTaskExecutionResulCreateReleaseFailure(taskId: String,
                                                                 executionId: String,
                                                                 message: String)
    extends CreateReleaseTaskExecutionResult

  case class CreateReleaseTaskExecutionResultStartReleaseFailure(taskId: String,
                                                                 executionId: String,
                                                                 createdReleaseId: String,
                                                                 message: String)
    extends CreateReleaseTaskExecutionResult

  // notification task execution result
  sealed trait NotificationTaskExecutionResult extends ExecutionResult

  case class NotificationTaskExecutionResulSuccess(taskId: String, executionId: String) extends NotificationTaskExecutionResult

  case class NotificationTaskExecutionResulFailure(taskId: String, executionId: String, message: String) extends NotificationTaskExecutionResult


  sealed trait UnhandledExecutionResult extends ExecutionResult

  case class UnhandledTaskExecutionResult(taskId: String, executionId: String) extends UnhandledExecutionResult

  case class UnhandledExceptionExecutionResult(message: String) extends UnhandledExecutionResult

  sealed trait FailJobExecutionResult extends ExecutionResult

  case class FailTaskJobExecutionResult(taskId: String, executionId: String, message: String) extends FailJobExecutionResult

  case object DoNothingExecutionResult extends FailJobExecutionResult

}

trait Worker extends PriorityOrdered {

  def execute: ExecuteJob

  def processResult: ProcessJobResult

  override def getOrder: Int = 0

}
