package com.xebialabs.xlrelease.spring.configuration;

import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

import com.xebialabs.xlrelease.booter.XlrBooter;
import com.xebialabs.xlrelease.plugin.classloading.XlrPluginClassLoader;

public class XlrBooterInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext> {

    @Override
    public void initialize(final ConfigurableApplicationContext applicationContext) {
        applicationContext.getBeanFactory().registerSingleton("xlrPluginClassloader", XlrPluginClassLoader.apply());
        applicationContext.getBeanFactory().registerSingleton("xlrBooter", XlrBooter.apply());
    }
}
