package com.xebialabs.xlrelease.views;

import java.util.List;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;

import static java.util.stream.Collectors.toList;

public class PhaseView {

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String id;

    private String title;

    private List<TaskView> tasks;

    public PhaseView(Phase phase) {
        this.id = phase.getId();
        this.title  = phase.getTitle();
        this.tasks = phase.getAllTasks().stream().map(TaskView::new).collect(toList());
    }

    public String getId() {
        return id;
    }

    public String getTitle() {
        return title;
    }

    public List<TaskView> getTasks() {
        return tasks;
    }
}
