package com.xebialabs.xlrelease.views;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.xebialabs.xlrelease.api.internal.EffectiveSecurity;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;

public class ReleaseOverviewView extends PlanItemFullView implements BaseView {
    private ReleaseStatus status;
    /**
     * A release is flagged if the release itself is flagged OR if one of its tasks is flagged
     * - releaseFlag contains flag status for the actual release
     * - flag contains flag status for the release OR its subtasks
     */
    private Flag releaseFlag;
    private Flag flag;
    private boolean archived;

    private Map<String, Object> syntheticProperties;
    private Map<String, ReleaseExtensionView> extensions;
    private String currentPhase;
    private TaskFullView currentTask;
    private List<PhaseOverviewView> phases;

    private Map<String, String> variables;

    private EffectiveSecurity security;

    private UserView owner;
    private List<String> tags;

    private ReleaseKind kind;

    /**
     * Execution duration in seconds
     */
    private Long executionDuration;

    public ReleaseStatus getStatus() {
        return status;
    }

    public void setStatus(final ReleaseStatus status) {
        this.status = status;
    }

    public Flag getReleaseFlag() {
        return releaseFlag;
    }

    public void setReleaseFlag(final Flag releaseFlag) {
        this.releaseFlag = releaseFlag;
    }

    public Flag getFlag() {
        return flag;
    }

    public void setFlag(final Flag flag) {
        this.flag = flag;
    }

    public boolean isArchived() {
        return archived;
    }

    public void setArchived(final boolean archived) {
        this.archived = archived;
    }

    public String getCurrentPhase() {
        return currentPhase;
    }

    public void setCurrentPhase(final String currentPhase) {
        this.currentPhase = currentPhase;
    }

    public TaskFullView getCurrentTask() {
        return currentTask;
    }

    public void setCurrentTask(final TaskFullView currentTask) {
        this.currentTask = currentTask;
    }

    public Map<String, Object> getSyntheticProperties() {
        return syntheticProperties;
    }

    public void setSyntheticProperties(final Map<String, Object> syntheticProperties) {
        this.syntheticProperties = syntheticProperties;
    }

    public Map<String, ReleaseExtensionView> getExtensions() {
        return extensions;
    }

    public List<PhaseOverviewView> getPhases() {
        return phases;
    }

    public void setPhases(final List<PhaseOverviewView> phases) {
        this.phases = phases;
    }

    @Override
    public void setExtensions(final Map<String, ReleaseExtensionView> extensions) {
        this.extensions = extensions;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public Map<String, String> getVariables() {
        return variables;
    }

    public UserView getOwner() {
        return owner;
    }

    public void setOwner(final UserView owner) {
        this.owner = owner;
    }

    public EffectiveSecurity getSecurity() {
        return security;
    }

    public void setSecurity(final EffectiveSecurity security) {
        this.security = security;
    }

    public List<String> getTags() {
        return tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public ReleaseKind getKind() {
        return kind;
    }

    public void setKind(final ReleaseKind kind) {
        this.kind = kind;
    }

    public Long getExecutionDuration() {
        if (null == executionDuration) {
            var now = Instant.now();
            var startInstant = getStartDate() == null ? now : getStartDate().toInstant();
            if (Arrays.asList(ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED).contains(getStatus())) {
                // end date, execution duration
                var endInstant = getEndDate() == null ? now : getEndDate().toInstant();
                executionDuration = Duration.between(startInstant, endInstant).getSeconds();
            } else {
                executionDuration = Duration.between(startInstant, now).getSeconds();
            }
        }
        return executionDuration;
    }
}
