package com.xebialabs.xlrelease.views;

import java.util.List;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.api.internal.EffectiveSecurity;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;

import static com.google.common.collect.Lists.newArrayList;

public class ReleaseTasks {

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String id;

    private String title;

    private ReleaseStatus status;

    private List<TaskFullView> tasks = newArrayList();

    private EffectiveSecurity security;

    public ReleaseTasks() {
    }

    public ReleaseTasks(String releaseId,
                        String releaseTitle,
                        String releaseStatus,
                        EffectiveSecurity releaseSecurity,
                        List<TaskFullView> tasks) {
        this.title = releaseTitle;
        this.id = releaseId;
        this.tasks = tasks;
        this.status = ReleaseStatus.valueOf(releaseStatus.toUpperCase());
        this.security = releaseSecurity;
    }


    public String getTitle() {
        return title;
    }

    public String getId() {
        return id;
    }

    public List<TaskFullView> getTasks() {
        return tasks;
    }

    public EffectiveSecurity getSecurity() {
        return security;
    }

    public ReleaseStatus getStatus() {
        return status;
    }
}
