package com.xebialabs.xlrelease.authentication

import org.springframework.context.ApplicationContext
import org.springframework.context.annotation.{Bean, Configuration, Primary}
import org.springframework.security.core.userdetails.UserDetailsService

@Configuration
class UserDetailsResolutionConfiguration {

  @Bean
  @Primary
  def defaultUserDetailsService(applicationContext: ApplicationContext): UserDetailsService = {
    val services = applicationContext.getBeansOfType(classOf[UserDetailsService]).values()
    if(services.size() > 1) {
      new DelegatingUserDetailsService(services)
    } else {
      services.iterator().next()
    }
  }
}
