package com.xebialabs.xlrelease.scheduler.strategies

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.deployit.plugin.api.validation
import com.xebialabs.xlrelease.features.settings.JobSchedulerStrategySettings
import com.xebialabs.xlrelease.scheduler.Job
import com.xebialabs.xlrelease.scheduler.strategies.JobSchedulerStrategy.ScheduleResult
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty
import scala.concurrent.duration.{DurationInt, FiniteDuration}

@Metadata(label = "Non-blocking backpressure",
  description = "")
class NonBlockingBackpressuredJobSchedulerStrategySettings extends JobSchedulerStrategySettings {

  @BeanProperty
  @XLProperty(label = "Response threshold",
    description = "Response threshold in milliseconds",
    defaultValue = "100",
    category = "input",
    isTransient = true,
    hidden = true
  )
  @validation.Range(minimum = 100, maximum = 10000)
  var responseThresholdMs: Int = _

  @BeanProperty
  @XLProperty(label = "Delay",
    description = "Job delay duration in milliseconds if threshold is reached",
    defaultValue = "1000",
    category = "input"
  )
  @validation.Range(minimum = 500, maximum = 10000)
  var delayDurationMs: Int = _

  @BeanProperty
  @XLProperty(label = "Response threshold ratio",
    description = "Response threshold ratio",
    defaultValue = "30",
    category = "input",
    isTransient = true,
    hidden = true
  )
  @validation.Range(minimum = 10, maximum = 100)
  var responseThresholdRatio: Int = _

  @BeanProperty
  @XLProperty(label = "Warning threshold",
    description = "Warning threshold in milliseconds",
    defaultValue = "60000",
    category = "input",
    isTransient = true,
    hidden = true
  )
  @validation.Range(minimum = 10000, maximum = 300000)
  var warningThresholdMs: Int = _

  override def schedule(job: Job): ScheduleResult = NonBlockingBackpressuredJobSchedulerStrategy.schedule(this)(job)

  def responseThreshold: FiniteDuration = responseThresholdMs.millis

  def delayDuration: FiniteDuration = delayDurationMs.millis

  def warningThreshold: FiniteDuration = warningThresholdMs.millis

}

