package com.xebialabs.xlrelease.script.groovy

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.script.{Jsr223ScriptExecutor, ScriptPermissionsProvider}
import org.codehaus.groovy.control.MultipleCompilationErrorsException
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.security.AccessControlContext
import javax.script.{ScriptContext, ScriptEngine, ScriptException}

@Component
class GroovyScriptExecutor @Autowired()(groovyEngineInstance: GroovyEngineInstance,
                                        scriptPermissionsProvider: ScriptPermissionsProvider,
                                        xlrConfig: XlrConfig)
  extends Jsr223ScriptExecutor(groovyEngineInstance,
    scriptPermissionsProvider,
    xlrConfig.isScriptSandboxEnabled,
    xlrConfig.repository.workDir) {

  lazy val scriptSandbox = new GroovyScriptSandbox()

  override protected def evalScriptPrivileged(engine: ScriptEngine,
                                              script: String,
                                              scriptContext: ScriptContext,
                                              accessControlContext: AccessControlContext): Object = {
    try {
      val doPrivilegedCall = () => super.doPrivileged(engine, script, scriptContext, accessControlContext)
      if (accessControlContext != null) {
        scriptSandbox.execute(doPrivilegedCall)
      } else {
        doPrivilegedCall()
      }
    } catch {
      case ex: ScriptException if ex.getCause != null && ex.getCause.isInstanceOf[MultipleCompilationErrorsException] =>
        throw new ScriptException(new SecurityException(ex.getCause.getMessage))
    }
  }
}
