package com.xebialabs.xlrelease.spring.configuration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.xlrelease.config.XlrConfig;

@Configuration
public class CookieConfiguration {

    @Bean
    public CookieSerializer cookieSerializer(ServerConfiguration serverConfiguration, XlrConfig xlrConfig) {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName("JSESSIONID");
        serializer.setUseHttpOnlyCookie(true);
        if (!serverConfiguration.isSsl()) {
            serializer.setUseSecureCookie(serverConfiguration.isSecureCookieEnabled());
        }
        serializer.setSameSite(xlrConfig.server_http_cookie_sameSite().getAttributeValue());
        return serializer;
    }
}
