/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.events.FolderVariableCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FolderVariableDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FolderVariableUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.FolderVariables;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.FolderVariableRepository;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import io.micrometer.core.annotation.Timed;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001B\u0007\u000f\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u0003G\u0001\u0011\u0005q\tC\u0003j\u0001\u0011\u0005!\u000eC\u0003o\u0001\u0011\u0005q\u000eC\u0003w\u0001\u0011\u0005q\u000fC\u0003{\u0001\u0011\u00051\u0010C\u0003\u007f\u0001\u0011\u0005q\u0010C\u0004\u0002\f\u0001!\t!!\u0004\t\u000f\u0005e\u0001\u0001\"\u0003\u0002\u001c\t)bi\u001c7eKJ4\u0016M]5bE2,7+\u001a:wS\u000e,'BA\b\u0011\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0005\n\u0002\u0013ad'/\u001a7fCN,'BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\u0011M>dG-\u001a:SKB|7/\u001b;pef\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\t\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002%C\t\u0001bi\u001c7eKJ\u0014V\r]8tSR|'/_\u0001\u0019M>dG-\u001a:WCJL\u0017M\u00197f%\u0016\u0004xn]5u_JL\bC\u0001\u0011(\u0013\tA\u0013E\u0001\rG_2$WM\u001d,be&\f'\r\\3SKB|7/\u001b;pef\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0003W9j\u0011\u0001\f\u0006\u0003[A\ta!\u001a<f]R\u001c\u0018BA\u0018-\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\tI\"TG\u000e\t\u0003g\u0001i\u0011A\u0004\u0005\u0006=\u0011\u0001\ra\b\u0005\u0006K\u0011\u0001\rA\n\u0005\u0006S\u0011\u0001\rA\u000b\u0015\u0003\ta\u0002\"!\u000f#\u000e\u0003iR!a\u000f\u001f\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002>}\u00059a-Y2u_JL(BA A\u0003\u0015\u0011W-\u00198t\u0015\t\t%)A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0019\u0015aA8sO&\u0011QI\u000f\u0002\n\u0003V$xn^5sK\u0012\f\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0003\u0011B\u0003\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\u0013Y\f'/[1cY\u0016\u001c(BA'\u0011\u0003\u0019!w.\\1j]&\u0011qJ\u0013\u0002\t-\u0006\u0014\u0018.\u00192mK\")\u0011+\u0002a\u0001%\u0006Qa/\u0019:jC\ndW-\u00133\u0011\u0005MSfB\u0001+Y!\t)&$D\u0001W\u0015\t9f#\u0001\u0004=e>|GOP\u0005\u00033j\ta\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011L\u0007\u0015\u0003\u000by\u0003\"aX4\u000e\u0003\u0001T!aO1\u000b\u0005\t\u001c\u0017\u0001B2pe\u0016T!\u0001Z3\u0002\u00155L7M]8nKR,'OC\u0001g\u0003\tIw.\u0003\u0002iA\n)A+[7fI\u0006!2M]3bi\u00164u\u000e\u001c3feZ\u000b'/[1cY\u0016$\"\u0001S6\t\u000b14\u0001\u0019\u0001%\u0002\u0011Y\f'/[1cY\u0016D#A\u00020\u00023\u001d,G/\u00117m\rJ|W.S7nK\u0012L\u0017\r^3QCJ,g\u000e\u001e\u000b\u0003aN\u0004\"!S9\n\u0005IT%a\u0004$pY\u0012,'OV1sS\u0006\u0014G.Z:\t\u000bQ<\u0001\u0019\u0001*\u0002!Y\f'/[1cY\u0016\u0004\u0016M]3oi&#\u0007FA\u0004_\u0003I9W\r^!mY\u001a\u0013x.\\!oG\u0016\u001cHO]=\u0015\u0005AD\b\"\u0002;\t\u0001\u0004\u0011\u0006F\u0001\u0005_\u0003Q)\b\u000fZ1uK\u001a{G\u000eZ3s-\u0006\u0014\u0018.\u00192mKR\u0011\u0001\n \u0005\u0006Y&\u0001\r\u0001\u0013\u0015\u0003\u0013y\u000bA\u0003Z3mKR,gi\u001c7eKJ4\u0016M]5bE2,G\u0003BA\u0001\u0003\u000f\u00012!GA\u0002\u0013\r\t)A\u0007\u0002\u0005+:LG\u000fC\u0003R\u0015\u0001\u0007!\u000b\u000b\u0002\u000b=\u0006Ia-\u001b8e\u0005f\\U-\u001f\u000b\u0006\u0011\u0006=\u00111\u0003\u0005\u0007\u0003#Y\u0001\u0019\u0001*\u0002\u0017Y\f'/[1cY\u0016\\U-\u001f\u0005\u0007\u0003+Y\u0001\u0019\u0001*\u0002!Y\f'/[1cY\u0016Du\u000e\u001c3fe&#\u0007FA\u0006_\u00035\u0019\u0007.Z2l'\u0006lW\rV=qKR1\u0011\u0011AA\u000f\u0003CAa!a\b\r\u0001\u0004A\u0015aB2veJ,g\u000e\u001e\u0005\u0007\u0003Ga\u0001\u0019\u0001%\u0002\u000fU\u0004H-\u0019;fI\"\u001a\u0001!a\n\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\fA\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003c\tYCA\u0004TKJ4\u0018nY3")
public class FolderVariableService {
    private final FolderRepository folderRepository;
    private final FolderVariableRepository folderVariableRepository;
    private final XLReleaseEventBus eventBus;

    @Timed
    public Variable findById(String variableId) {
        return this.folderVariableRepository.findById(variableId);
    }

    @Timed
    public Variable createFolderVariable(Variable variable) {
        Option option;
        String string = variable.getFolderId();
        if (string == null || (option = IdMatchers.FolderId$.MODULE$.unapply(string)).isEmpty()) {
            throw new Checks.IncorrectArgumentException("You can't add variable with id='" + string + "'", new Object[0]);
        }
        String folderId = (String)option.get();
        Checks.checkArgument((boolean)this.folderRepository.exists(folderId), (String)("Folder with id='" + folderId + "' doesn't exist"), (Object[])new Object[0]);
        variable.checkFolderVariableValidity();
        if (variable.isPassword()) {
            ((PasswordStringVariable)variable).checkExternalPasswordVariable();
        }
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)None$.MODULE$, (ConfigurationItem)variable);
        Variable created = this.folderVariableRepository.create(variable);
        this.eventBus.publish((XLReleaseEvent)new FolderVariableCreatedEvent(created, null));
        return created;
    }

    @Timed
    public FolderVariables getAllFromImmediateParent(String variableParentId) {
        return new FolderVariables(variableParentId, this.folderVariableRepository.getAllFromParent(variableParentId));
    }

    @Timed
    public FolderVariables getAllFromAncestry(String variableParentId) {
        return new FolderVariables(variableParentId, this.folderVariableRepository.getAllFromAncestry(variableParentId));
    }

    @Timed
    public Variable updateFolderVariable(Variable variable) {
        variable.checkFolderVariableValidity();
        Variable current = this.folderVariableRepository.findById(variable.getId());
        this.checkSameType(current, variable);
        String string = current.getFolderId();
        String string2 = variable.getFolderId();
        Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)"Cannot change folderId", (Object[])new Object[0]);
        if (variable.isPassword()) {
            ((PasswordStringVariable)variable).checkExternalPasswordVariable();
        }
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)new Some((Object)current), (ConfigurationItem)variable);
        if (variable.getValueProvider() != null) {
            variable.getValueProvider().setVariable(variable);
        }
        Variable updated = this.folderVariableRepository.update(variable);
        this.eventBus.publish((XLReleaseEvent)new FolderVariableUpdatedEvent(current, updated, null));
        return updated;
    }

    @Timed
    public void deleteFolderVariable(String variableId) {
        Variable variable = this.findById(variableId);
        this.folderVariableRepository.delete(variableId);
        this.eventBus.publish((XLReleaseEvent)new FolderVariableDeletedEvent(variable, null));
    }

    @Timed
    public Variable findByKey(String variableKey, String variableHolderId) {
        return this.folderVariableRepository.findByKey(variableKey, variableHolderId);
    }

    private void checkSameType(Variable current, Variable updated) {
        if (!current.getType().equals((Object)updated.getType())) {
            throw new IllegalArgumentException("Cannot change type of variable " + updated.getId() + " from " + current.getType() + " to " + updated.getType());
        }
    }

    @Autowired
    public FolderVariableService(FolderRepository folderRepository, FolderVariableRepository folderVariableRepository, XLReleaseEventBus eventBus) {
        this.folderRepository = folderRepository;
        this.folderVariableRepository = folderVariableRepository;
        this.eventBus = eventBus;
    }
}

