/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.plumbing.CurrentVersion;
import com.xebialabs.xlrelease.XLReleaseBootstrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.http.BadMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionEnforcerFilter
implements Filter {
    private static final String VERSION_PARAMETER = "xlrv";
    private static final Pattern VERSION_PATTERN = Pattern.compile("^[0-9]+\\.[0-9]+(\\.[0-9]+)?(-(alpha|beta|rc|SNAPSHOT|[0-9]+)(\\.[0-9]+)?)?$");
    private static final Logger logger = LoggerFactory.getLogger(VersionEnforcerFilter.class);
    private String serverVersion;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.serverVersion = CurrentVersion.get();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean doFilter = true;
        try {
            String[] values = request.getParameterValues(VERSION_PARAMETER);
            if (values != null) {
                String clientVersion = values[0];
                if (!this.isClientVersionValid(clientVersion)) {
                    response.setContentType("text/plain");
                    response.getWriter().write(String.format("%s : provided version format is incorrect", XLReleaseBootstrapper.PRODUCT_DIGITALAI()));
                    ((HttpServletResponse)response).setStatus(410);
                    doFilter = false;
                }
                if (!clientVersion.equals(this.serverVersion) && doFilter) {
                    response.setContentType("text/plain");
                    response.getWriter().write(String.format("%s version changed : you are using %s, but server version is now %s", XLReleaseBootstrapper.PRODUCT_DIGITALAI(), clientVersion, this.serverVersion));
                    ((HttpServletResponse)response).setStatus(410);
                    doFilter = false;
                }
            }
        }
        catch (BadMessageException jettyException) {
            logger.debug("Jetty was unable to handle request. Will pass request to another filter in the chain.", (Throwable)jettyException);
        }
        if (doFilter) {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private boolean isClientVersionValid(String clientVersion) {
        Matcher versionMatcher = VERSION_PATTERN.matcher(clientVersion);
        return versionMatcher.matches();
    }
}

