/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.xebialabs.xlplatform.cluster.ClusterMode;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.metrics.MetricsConfiguration$;
import com.xebialabs.xlrelease.repository.JobRunnerRepository;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRecoveryLogic;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.NodeId;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.WorkerThread;
import com.xebialabs.xlrelease.scheduler.domain.LocalJobRunner$;
import com.xebialabs.xlrelease.scheduler.service.JobService;
import com.xebialabs.xlrelease.scheduler.workers.CompositeWorker;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pekko.actor.Address;
import org.slf4j.Marker;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h\u0001B\u0012%\u00015B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005u!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003D\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011A\u0003!Q1A\u0005\u0002EC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t3\u0002\u0011)\u0019!C\u00015\"A\u0011\r\u0001B\u0001B\u0003%1\f\u0003\u0005c\u0001\t\u0015\r\u0011\"\u0001d\u0011!Q\u0007A!A!\u0002\u0013!\u0007\u0002C6\u0001\u0005\u000b\u0007I\u0011\u00017\t\u0011A\u0004!\u0011!Q\u0001\n5D\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006IA\u001d\u0005\u0006}\u0002!\ta \u0005\u000b\u0003[\u0001\u0001R1A\u0005\n\u0005=\u0002bCA\u001c\u0001\u0001\u0007\t\u0019!C\u0005\u0003sA1\"a\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002R!Y\u0011Q\f\u0001A\u0002\u0003\u0005\u000b\u0015BA\u001e\u0011%\ty\u0006\u0001b\u0001\n\u0013\t\t\u0007\u0003\u0005\u0002p\u0001\u0001\u000b\u0011BA2\u0011%\t\t\b\u0001b\u0001\n\u0013\t\u0019\b\u0003\u0005\u0002\f\u0002\u0001\u000b\u0011BA;\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!!%\u0001\t\u0003\ty\tC\u0004\u0002\u0014\u0002!I!a$\t\u000f\u0005U\u0005\u0001\"\u0003\u0002\u0010\"9\u0011q\u0013\u0001\u0005\n\u0005e\u0002bBAM\u0001\u0011\u0005\u0011q\u0012\u0005\b\u00037\u0003A\u0011AAO\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!a,\u0001\t\u0003\t\t\fC\u0004\u0002N\u0002!I!a4\u0003\u0017]{'o['b]\u0006<WM\u001d\u0006\u0003K\u0019\n\u0011b]2iK\u0012,H.\u001a:\u000b\u0005\u001dB\u0013!\u0003=me\u0016dW-Y:f\u0015\tI#&A\u0005yK\nL\u0017\r\\1cg*\t1&A\u0002d_6\u001c\u0001aE\u0002\u0001]Q\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u001b7\u001b\u0005!\u0013BA\u001c%\u0005AQuN\u0019*fG>4XM]=M_\u001eL7-A\u0005yYJ\u001cuN\u001c4jOV\t!\b\u0005\u0002<}5\tAH\u0003\u0002>M\u000511m\u001c8gS\u001eL!a\u0010\u001f\u0003\u0013ac'oQ8oM&<\u0017A\u0003=me\u000e{gNZ5hA\u0005A!n\u001c2Rk\u0016,X-F\u0001D!\t)D)\u0003\u0002FI\tA!j\u001c2Rk\u0016,X-A\u0005k_\n\fV/Z;fA\u0005y1m\\7q_NLG/Z,pe.,'/F\u0001J!\tQU*D\u0001L\u0015\taE%A\u0004x_J\\WM]:\n\u00059[%aD\"p[B|7/\u001b;f/>\u00148.\u001a:\u0002!\r|W\u000e]8tSR,wk\u001c:lKJ\u0004\u0013A\u00036pEN+'O^5dKV\t!\u000b\u0005\u0002T-6\tAK\u0003\u0002VI\u000591/\u001a:wS\u000e,\u0017BA,U\u0005)QuNY*feZL7-Z\u0001\fU>\u00147+\u001a:wS\u000e,\u0007%A\nk_\n\u0014VO\u001c8feJ+\u0007o\\:ji>\u0014\u00180F\u0001\\!\tav,D\u0001^\u0015\tqf%\u0001\u0006sKB|7/\u001b;pefL!\u0001Y/\u0003'){'MU;o]\u0016\u0014(+\u001a9pg&$xN]=\u0002))|'MU;o]\u0016\u0014(+\u001a9pg&$xN]=!\u0003M\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f+\u0005!\u0007CA3i\u001b\u00051'BA4'\u0003\u0019\t7\r^8sg&\u0011\u0011N\u001a\u0002\u0014%\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u0001\u0015e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-\u001a\u0011\u0002#\u0005\u001cGo\u001c:TsN$X-\u001c%pY\u0012,'/F\u0001n!\t)g.\u0003\u0002pM\n\t\u0012i\u0019;peNK8\u000f^3n\u0011>dG-\u001a:\u0002%\u0005\u001cGo\u001c:TsN$X-\u001c%pY\u0012,'\u000fI\u0001\u000e[\u0016$XM\u001d*fO&\u001cHO]=\u0011\u0005MdX\"\u0001;\u000b\u0005U4\u0018AC5ogR\u0014X/\\3oi*\u0011q\u000f_\u0001\u0005G>\u0014XM\u0003\u0002zu\u0006QQ.[2s_6,G/\u001a:\u000b\u0003m\f!![8\n\u0005u$(!D'fi\u0016\u0014(+Z4jgR\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003\u0003\t\u0019!!\u0002\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\tY\u0003\u0005\u00026\u0001!)\u0001\b\u0005a\u0001u!)\u0011\t\u0005a\u0001\u0007\")q\t\u0005a\u0001\u0013\")\u0001\u000b\u0005a\u0001%\")\u0011\f\u0005a\u00017\")!\r\u0005a\u0001I\")1\u000e\u0005a\u0001[\"\"\u0011qBA\n!\u0011\t)\"a\n\u000e\u0005\u0005]!\u0002BA\r\u00037\t!\"\u00198o_R\fG/[8o\u0015\u0011\ti\"a\b\u0002\u000f\r|g\u000e^3yi*!\u0011\u0011EA\u0012\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA\u0013\u0003\ry'oZ\u0005\u0005\u0003S\t9B\u0001\u0003MCjL\b\"B9\u0011\u0001\u0004\u0011\u0018aD7bqRC'/Z1eg\u000e{WO\u001c;\u0016\u0005\u0005E\u0002cA\u0018\u00024%\u0019\u0011Q\u0007\u0019\u0003\u0007%sG/\u0001\u0006uQJ,\u0017\r\u001a)p_2,\"!a\u000f\u0011\t\u0005u\u00121J\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\u0015\u0013qI\u0001\u0005kRLGN\u0003\u0002\u0002J\u0005!!.\u0019<b\u0013\u0011\ti%a\u0010\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016\fa\u0002\u001e5sK\u0006$\u0007k\\8m?\u0012*\u0017\u000f\u0006\u0003\u0002T\u0005e\u0003cA\u0018\u0002V%\u0019\u0011q\u000b\u0019\u0003\tUs\u0017\u000e\u001e\u0005\n\u00037\u001a\u0012\u0011!a\u0001\u0003w\t1\u0001\u001f\u00132\u0003-!\bN]3bIB{w\u000e\u001c\u0011\u0002%MDW\u000f\u001e3po:Le\u000e\u0015:pOJ,7o]\u000b\u0003\u0003G\u0002B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0005\u0003S\ny$\u0001\u0004bi>l\u0017nY\u0005\u0005\u0003[\n9GA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u0014g\",H\u000fZ8x]&s\u0007K]8he\u0016\u001c8\u000fI\u0001\u000eo>\u00148.\u001a:UQJ,\u0017\rZ:\u0016\u0005\u0005U\u0004CBA<\u0003\u0003\u000b))\u0004\u0002\u0002z)!\u00111PA?\u0003\u001diW\u000f^1cY\u0016T1!a 1\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0007\u000bIH\u0001\u0004Ck\u001a4WM\u001d\t\u0004k\u0005\u001d\u0015bAAEI\taqk\u001c:lKJ$\u0006N]3bI\u0006qqo\u001c:lKJ$\u0006N]3bIN\u0004\u0013!B:uCJ$HCAA*\u0003-\u0011XmY8wKJTuNY:\u0002\u0019M$\u0018M\u001d;UQJ,\u0017\rZ:\u0002\tM$x\u000e]\u0001\u000eO\u0016$H\u000b\u001b:fC\u0012\u0004vn\u001c7\u0002\u0011MDW\u000f\u001e3po:\faa];c[&$H\u0003BA*\u0003?Cq!!) \u0001\u0004\t\u0019+A\u0002k_\n\u00042!NAS\u0013\r\t9\u000b\n\u0002\u0004\u0015>\u0014\u0017a\u0002:fa2\f7-\u001a\u000b\u0005\u0003'\ni\u000bC\u0004\u0002\"\u0002\u0002\r!a)\u0002!\u0005\u0014wN\u001d;K_\n\u0014\u0015\u0010V1tW&#G\u0003BA*\u0003gCq!!.\"\u0001\u0004\t9,\u0001\u0004uCN\\\u0017\n\u001a\t\u0005\u0003s\u000b9M\u0004\u0003\u0002<\u0006\r\u0007cAA_a5\u0011\u0011q\u0018\u0006\u0004\u0003\u0003d\u0013A\u0002\u001fs_>$h(C\u0002\u0002FB\na\u0001\u0015:fI\u00164\u0017\u0002BAe\u0003\u0017\u0014aa\u0015;sS:<'bAAca\u0005A\"/Z9vKN$(+\u001e8oKJ$v.\u00112peR$\u0016m]6\u0015\t\u0005M\u0013\u0011\u001b\u0005\b\u0003k\u0013\u0003\u0019AA\\Q\r\u0001\u0011Q\u001b\t\u0005\u0003/\fi.\u0004\u0002\u0002Z*!\u00111\\A\u0010\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003?\fINA\u0004TKJ4\u0018nY3")
public class WorkManager
implements JobRecoveryLogic {
    private int maxThreadsCount;
    private final XlrConfig xlrConfig;
    private final JobQueue jobQueue;
    private final CompositeWorker compositeWorker;
    private final JobService jobService;
    private final JobRunnerRepository jobRunnerRepository;
    private final ReleaseActorService releaseActorService;
    private final ActorSystemHolder actorSystemHolder;
    private final MeterRegistry meterRegistry;
    private ExecutorService threadPool;
    private final AtomicBoolean shutdownInProgress;
    private final Buffer<WorkerThread> workerThreads;
    private String nodeId;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void recoverAllJobs() {
        JobRecoveryLogic.recoverAllJobs$(this);
    }

    @Override
    public void recoverJobs(String nodeId) {
        JobRecoveryLogic.recoverJobs$(this, nodeId);
    }

    @Override
    public String convertAddressToNodeId(Address address) {
        return NodeId.convertAddressToNodeId$(this, address);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private String nodeId$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.nodeId = NodeId.nodeId$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.nodeId;
    }

    @Override
    public String nodeId() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.nodeId$lzycompute();
        }
        return this.nodeId;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    @Override
    public JobQueue jobQueue() {
        return this.jobQueue;
    }

    public CompositeWorker compositeWorker() {
        return this.compositeWorker;
    }

    @Override
    public JobService jobService() {
        return this.jobService;
    }

    public JobRunnerRepository jobRunnerRepository() {
        return this.jobRunnerRepository;
    }

    @Override
    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    @Override
    public ActorSystemHolder actorSystemHolder() {
        return this.actorSystemHolder;
    }

    private int maxThreadsCount$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.maxThreadsCount = this.xlrConfig().executors().scheduler().maxThreadsCount();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.maxThreadsCount;
    }

    private int maxThreadsCount() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.maxThreadsCount$lzycompute();
        }
        return this.maxThreadsCount;
    }

    private ExecutorService threadPool() {
        return this.threadPool;
    }

    private void threadPool_$eq(ExecutorService x$1) {
        this.threadPool = x$1;
    }

    private AtomicBoolean shutdownInProgress() {
        return this.shutdownInProgress;
    }

    private Buffer<WorkerThread> workerThreads() {
        return this.workerThreads;
    }

    public void start() {
        this.logger().info((Function0 & Serializable)() -> "Starting work manager with " + this.maxThreadsCount() + " threads");
        this.stop();
        this.jobQueue().cancelIf(x$2 -> true);
        this.jobQueue().start();
        if (this.xlrConfig().maintenanceModeEnabled()) {
            this.logger().debug((Function0 & Serializable)() -> "[MAINTENANCE MODE] Job recovery - DISABLED");
        } else {
            this.recoverJobs();
        }
        this.startThreads();
        this.logger().info((Function0 & Serializable)() -> "Started work manager");
    }

    public void recoverJobs() {
        try {
            this.logger().debug((Function0 & Serializable)() -> "Job recovery started");
            ClusterMode clusterMode = this.xlrConfig().cluster().mode();
            if (ClusterMode.Standalone$.MODULE$.equals(clusterMode)) {
                this.recoverAllJobs();
            } else {
                this.recoverJobs(this.nodeId());
                this.recoverJobs(null);
            }
            this.logger().debug((Function0 & Serializable)() -> "Job recovery completed, proceeding with startup");
        }
        catch (Throwable t) {
            this.logger().error((Function0 & Serializable)() -> "Job recovery failed", (Function0 & Serializable)() -> t);
        }
    }

    private void startThreads() {
        this.shutdownInProgress().set(false);
        this.threadPool_$eq(this.getThreadPool());
        this.workerThreads().clear();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.maxThreadsCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            int n = x$3;
            WorkerThread workerThread = new WorkerThread(this.jobQueue(), this.compositeWorker());
            this.workerThreads().$plus$eq((Object)workerThread);
            this.threadPool().execute(workerThread);
        });
    }

    private void stop() {
        this.workerThreads().foreach((Function1 & Serializable)worker -> {
            worker.stop();
            return BoxedUnit.UNIT;
        });
        this.workerThreads().clear();
        this.jobQueue().stop();
    }

    private ExecutorService getThreadPool() {
        ExecutorService executors = Executors.newFixedThreadPool(this.maxThreadsCount(), PrefixedThreadFactory$.MODULE$.apply("task-execution", PrefixedThreadFactory$.MODULE$.apply$default$2()));
        if (this.xlrConfig().metrics().enabled()) {
            return ExecutorServiceMetrics.monitor((MeterRegistry)this.meterRegistry, (ExecutorService)executors, (String)"task-execution", (Tag[])new Tag[]{MetricsConfiguration$.MODULE$.TAG_EXECUTOR()});
        }
        return executors;
    }

    public void shutdown() {
        if (this.shutdownInProgress().compareAndSet(false, true)) {
            this.logger().info((Function0 & Serializable)() -> "starting shutdown");
            this.stop();
            this.threadPool().shutdown();
            if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                this.logger().warn((Function0 & Serializable)() -> "There are tasks, that did not complete within shutdown grace period, going to interrupt those tasks");
                this.threadPool().shutdownNow();
                if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                    this.logger().error((Function0 & Serializable)() -> "There are tasks, that could not be interrupted, giving up");
                }
            }
            this.jobQueue().cancelIf(x$4 -> true);
            this.shutdownInProgress().set(false);
            return;
        }
        this.logger().info((Function0 & Serializable)() -> "skipping shutdown, because shutdown already happened or in progress");
    }

    public void submit(Job job) {
        this.jobQueue().submit(job);
    }

    public void replace(Job job) {
        this.jobQueue().replace(job);
    }

    public void abortJobByTaskId(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> "Aborting scheduled job " + taskId);
        this.requestRunnerToAbortTask(taskId);
        this.jobService().deleteByTaskId(taskId);
        this.jobQueue().cancelIf(x0$1 -> {
            Job job = x0$1;
            if (job instanceof TaskJob) {
                TaskJob taskJob = (TaskJob)job;
                return taskJob.taskId().equals(taskId);
            }
            return false;
        });
    }

    private void requestRunnerToAbortTask(String taskId) {
        this.jobService().findByTaskId(taskId).foreach((Function1 & Serializable)jobRow -> {
            WorkManager.$anonfun$requestRunnerToAbortTask$1(this, taskId, jobRow);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$requestRunnerToAbortTask$1(WorkManager $this, String taskId$2, JobRow jobRow) {
        JobType jobType = jobRow.jobType();
        JobType jobType2 = JobType.CONTAINER_TASK;
        if (!(jobType != null ? !((Object)((Object)jobType)).equals((Object)jobType2) : jobType2 != null)) {
            if (new .colon.colon((Object)JobStatus.RESERVED, (List)new .colon.colon((Object)JobStatus.RUNNING, (List)Nil$.MODULE$)).contains((Object)jobRow.status()) && jobRow.runnerId() != null) {
                Option<? extends JobRunner> option = $this.jobRunnerRepository().findRunner(jobRow.runnerId());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    JobRunner runner = (JobRunner)some.value();
                    runner.abortJob(jobRow.id(), jobRow.executionId());
                } else if (None$.MODULE$.equals(option)) {
                    $this.logger().error((Function0 & Serializable)() -> "Can't find runner [" + jobRow.runnerId() + "]. Can't request runner to abort the job [" + jobRow.id() + "]");
                } else {
                    throw new MatchError(option);
                }
                JobStatus jobStatus = jobRow.status();
                JobStatus jobStatus2 = JobStatus.RESERVED;
                if (!(jobStatus != null ? !((Object)((Object)jobStatus)).equals((Object)jobStatus2) : jobStatus2 != null)) {
                    $this.releaseActorService().failTaskAsync(taskId$2, "Task was aborted", User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)None$.MODULE$);
                    return;
                }
                return;
            }
            JobStatus jobStatus = jobRow.status();
            JobStatus jobStatus3 = JobStatus.QUEUED;
            if (!(jobStatus != null ? !((Object)((Object)jobStatus)).equals((Object)jobStatus3) : jobStatus3 != null)) {
                $this.releaseActorService().failTaskAsync(taskId$2, "Task was aborted", User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)None$.MODULE$);
                return;
            }
            return;
        }
        LocalJobRunner$.MODULE$.abortJob(jobRow.id(), jobRow.executionId());
    }

    public WorkManager(XlrConfig xlrConfig, JobQueue jobQueue, CompositeWorker compositeWorker, JobService jobService, JobRunnerRepository jobRunnerRepository, ReleaseActorService releaseActorService, @Lazy ActorSystemHolder actorSystemHolder, MeterRegistry meterRegistry) {
        this.xlrConfig = xlrConfig;
        this.jobQueue = jobQueue;
        this.compositeWorker = compositeWorker;
        this.jobService = jobService;
        this.jobRunnerRepository = jobRunnerRepository;
        this.releaseActorService = releaseActorService;
        this.actorSystemHolder = actorSystemHolder;
        this.meterRegistry = meterRegistry;
        Logging.$init$((Logging)this);
        NodeId.$init$(this);
        JobRecoveryLogic.$init$(this);
        this.shutdownInProgress = new AtomicBoolean(false);
        this.workerThreads = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

