package com.xebialabs.xlrelease.api.internal.converters

import com.xebialabs.xlrelease.configuration.CustomLogoSettings
import com.xebialabs.xlrelease.views.CustomLogoSettingsView
import org.springframework.stereotype.Component

import java.io.{ByteArrayOutputStream, InputStream}
import java.util.Base64
import scala.util.Using

@Component
class CustomLogoSettingsConverter {

  def from(fileName: String, contentType: String, inputStream: InputStream): CustomLogoSettings = {
    var customLogoSettings: CustomLogoSettings = null

    Using.resource(inputStream) { imageInFile =>
      var in = -1
      val buffer = new ByteArrayOutputStream
      while ( {
        in = imageInFile.read
        in != -1
      }) {
        buffer.write(in)
      }
      val imageData = buffer.toByteArray
      imageInFile.read(imageData)

      customLogoSettings = new CustomLogoSettings
      customLogoSettings.setFilename(fileName)
      customLogoSettings.setContentType(contentType)
      customLogoSettings.setContent(Base64.getEncoder.encodeToString(imageData))
    }

    customLogoSettings
  }

  def toView(customLogoSettings: CustomLogoSettings): CustomLogoSettingsView = {
    val imageByteArray = Base64.getDecoder.decode(customLogoSettings.getContent)
    new CustomLogoSettingsView(customLogoSettings.getFilename, customLogoSettings.getContentType, imageByteArray)
  }

}
