package com.xebialabs.xlrelease.scheduler.workers

import com.xebialabs.xlrelease.authentication.AuthenticationSupport
import com.xebialabs.xlrelease.domain.BaseScriptTask
import com.xebialabs.xlrelease.script.ScriptService

import scala.jdk.CollectionConverters._

trait ScriptServiceSupport extends AuthenticationSupport {
  def scriptServicesList: java.util.List[ScriptService]

  val scriptServices: java.util.Map[String, ScriptService] = scriptServicesList.asScala.map(s => s.engine() -> s).toMap.asJava

  protected def scriptServiceFor(task: BaseScriptTask): ScriptService = scriptServices.get(task.getEngine)
}
