package com.xebialabs.xlrelease.script.jython

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.ScriptTask.JYTHON_ENGINE
import com.xebialabs.xlrelease.spring.configuration.ExecutorNames._
import com.xebialabs.xlrelease.script.{DefaultScriptService, ScriptLifeCycle, ScriptVariables}
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.security.authentication.AuthenticationService
import com.xebialabs.xlrelease.service._
import org.apache.commons.io.FilenameUtils
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.stereotype.Service

import java.util.concurrent.ScheduledExecutorService

@Service
class JythonScriptService(scriptLifeCycle: ScriptLifeCycle,
                          jythonScriptExecutor: JythonScriptExecutor,
                          authenticationService: AuthenticationService,
                          releaseService: ReleaseService,
                          scriptVariables: ScriptVariables,
                          permissions: PermissionChecker,
                          commentService: CommentService,
                          xlrConfig: XlrConfig,
                          attachmentService: AttachmentService,
                          configurationVariableService: ConfigurationVariableService,
                          configurationService: ConfigurationService,
                          @Qualifier(TIMEOUT_EXECUTOR_NAME) timeoutExecutor: ScheduledExecutorService,
                          @Qualifier(AUXILIARY_EXECUTOR_NAME) auxiliaryExecutor: ScheduledExecutorService,
                          @Qualifier(POLLING_EXECUTOR_NAME) pollingExecutor: ScheduledExecutorService
                         )
  extends DefaultScriptService(
    scriptLifeCycle,
    jythonScriptExecutor,
    authenticationService,
    releaseService,
    scriptVariables,
    permissions,
    commentService,
    xlrConfig,
    attachmentService,
    configurationVariableService,
    configurationService,
    timeoutExecutor,
    auxiliaryExecutor,
    pollingExecutor) {

  override def engine = JYTHON_ENGINE

  override def accepts(filename: String) = "py" == FilenameUtils.getExtension(filename)
}