package com.xebialabs.xlrelease.service

import com.xebialabs.deployit.plugin.api.reflect.Type
import io.micrometer.core.annotation.Timed

trait CiIdService {
  /**
   * Returns next possible unique ID for a new CI of given type within given parent.
   */
  def getUniqueId(t: Type, parentId: String): String

  /**
   * Returns next possible unique ID for a new CI of given type prefix within given parent.
   */
  def getUniqueId(t: String, parentId: String): String

  /**
   * Checks if generated id is present in existing list or not and returns next possible unique ID for a new CI of given type within given parent.
   */
  @Timed
  def getUniqueId(t: Type, parentId: String, existingChildIds: Set[String] = Set()): String = {
    var id: String = null
    do {
      id = getUniqueId(t, parentId)
    } while (existingChildIds.contains(id))
    id
  }
}
